/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nonnull;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BucketPickupHandlerWrapper
implements IFluidHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IBucketPickupHandler bucketPickupHandler;
    protected final World world;
    protected final BlockPos blockPos;

    public BucketPickupHandlerWrapper(IBucketPickupHandler bucketPickupHandler, World world, BlockPos blockPos) {
        this.bucketPickupHandler = bucketPickupHandler;
        this.world = world;
        this.blockPos = blockPos;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        FluidState fluidState;
        if (tank == 0 && !(fluidState = this.world.func_204610_c(this.blockPos)).func_206888_e()) {
            return new FluidStack(fluidState.func_206886_c(), 1000);
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity(int tank) {
        return 1000;
    }

    @Override
    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Override
    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidState fluidState;
        if (!resource.isEmpty() && 1000 <= resource.getAmount() && !(fluidState = this.world.func_204610_c(this.blockPos)).func_206888_e() && resource.getFluid() == fluidState.func_206886_c()) {
            if (action.execute()) {
                Fluid fluid = this.bucketPickupHandler.func_204508_a((IWorld)this.world, this.blockPos, this.world.func_180495_p(this.blockPos));
                if (fluid != Fluids.field_204541_a) {
                    FluidStack extracted = new FluidStack(fluid, 1000);
                    if (!resource.isFluidEqual(extracted)) {
                        LOGGER.error("Fluid removed without successfully being picked up. Fluid {} at {} in {} matched requested type, but after performing pickup was {}.", (Object)fluidState.func_206886_c().getRegistryName(), (Object)this.blockPos, (Object)this.world.func_234923_W_().func_240901_a_(), (Object)fluid.getRegistryName());
                        return FluidStack.EMPTY;
                    }
                    return extracted;
                }
            } else {
                FluidStack extracted = new FluidStack(fluidState.func_206886_c(), 1000);
                if (resource.isFluidEqual(extracted)) {
                    return extracted;
                }
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidState fluidState;
        if (1000 <= maxDrain && !(fluidState = this.world.func_204610_c(this.blockPos)).func_206888_e()) {
            if (action.simulate()) {
                return new FluidStack(fluidState.func_206886_c(), 1000);
            }
            Fluid fluid = this.bucketPickupHandler.func_204508_a((IWorld)this.world, this.blockPos, this.world.func_180495_p(this.blockPos));
            if (fluid != Fluids.field_204541_a) {
                return new FluidStack(fluid, 1000);
            }
        }
        return FluidStack.EMPTY;
    }
}

