/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui.screen;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.client.ClientHooks;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadingErrorScreen
extends ErrorScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path modsDir;
    private final Path logFile;
    private final List<ModLoadingException> modLoadErrors;
    private final List<ModLoadingWarning> modLoadWarnings;
    private final Path dumpedLocation;
    private LoadingEntryList entryList;
    private ITextComponent errorHeader;
    private ITextComponent warningHeader;

    public LoadingErrorScreen(LoadingFailedException loadingException, List<ModLoadingWarning> warnings, File dumpedLocation) {
        super((ITextComponent)new StringTextComponent("Loading Error"), null);
        this.modLoadWarnings = warnings;
        this.modLoadErrors = loadingException == null ? Collections.emptyList() : loadingException.getErrors();
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        this.dumpedLocation = dumpedLocation != null ? dumpedLocation.toPath() : null;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.errorHeader = new StringTextComponent(TextFormatting.RED + ForgeI18n.parseMessage("fml.loadingerrorscreen.errorheader", this.modLoadErrors.size()) + TextFormatting.RESET);
        this.warningHeader = new StringTextComponent(TextFormatting.YELLOW + ForgeI18n.parseMessage("fml.loadingerrorscreen.warningheader", this.modLoadErrors.size()) + TextFormatting.RESET);
        int yOffset = 46;
        this.func_230480_a_((Widget)new ExtendedButton(50, this.field_230709_l_ - yOffset, this.field_230708_k_ / 2 - 55, 20, (ITextComponent)new StringTextComponent(ForgeI18n.parseMessage("fml.button.open.mods.folder", new Object[0])), b -> Util.func_110647_a().func_195641_a(this.modsDir.toFile())));
        this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 2 + 5, this.field_230709_l_ - yOffset, this.field_230708_k_ / 2 - 55, 20, (ITextComponent)new StringTextComponent(ForgeI18n.parseMessage("fml.button.open.file", this.logFile.getFileName())), b -> Util.func_110647_a().func_195641_a(this.logFile.toFile())));
        if (this.modLoadErrors.isEmpty()) {
            this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 4, this.field_230709_l_ - 24, this.field_230708_k_ / 2, 20, (ITextComponent)new StringTextComponent(ForgeI18n.parseMessage("fml.button.continue.launch", new Object[0])), b -> {
                ClientHooks.logMissingTextureErrors();
                this.field_230706_i_.func_147108_a(null);
            }));
        } else {
            this.func_230480_a_((Widget)new ExtendedButton(this.field_230708_k_ / 4, this.field_230709_l_ - 24, this.field_230708_k_ / 2, 20, (ITextComponent)new StringTextComponent(ForgeI18n.parseMessage("fml.button.open.file", this.dumpedLocation.getFileName())), b -> Util.func_110647_a().func_195641_a(this.dumpedLocation.toFile())));
        }
        this.entryList = new LoadingEntryList(this, this.modLoadErrors, this.modLoadWarnings);
        this.field_230705_e_.add(this.entryList);
        this.func_231035_a_((IGuiEventListener)this.entryList);
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        this.entryList.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.drawMultiLineCenteredString(mStack, this.field_230712_o_, this.modLoadErrors.isEmpty() ? this.warningHeader : this.errorHeader, this.field_230708_k_ / 2, 10);
        this.field_230710_m_.forEach(button -> button.func_230430_a_(mStack, mouseX, mouseY, partialTicks));
    }

    private void drawMultiLineCenteredString(MatrixStack mStack, FontRenderer fr, ITextComponent str, int x, int y) {
        for (IReorderingProcessor s : fr.func_238425_b_((ITextProperties)str, this.field_230708_k_)) {
            fr.func_238407_a_(mStack, s, (float)((double)x - (double)fr.func_243245_a(s) / 2.0), (float)y, 0xFFFFFF);
            Objects.requireNonNull(fr);
            y += 9;
        }
    }

    public static class LoadingEntryList
    extends ExtendedList<LoadingMessageEntry> {
        LoadingEntryList(LoadingErrorScreen parent, List<ModLoadingException> errors, List<ModLoadingWarning> warnings) {
            boolean both;
            Minecraft minecraft = parent.field_230706_i_;
            int n = parent.field_230708_k_;
            int n2 = parent.field_230709_l_;
            int n3 = parent.field_230709_l_ - 50;
            Objects.requireNonNull(((LoadingErrorScreen)parent).field_230706_i_.field_71466_p);
            super(minecraft, n, n2, 35, n3, 2 * 9 + 8);
            boolean bl = both = !errors.isEmpty() && !warnings.isEmpty();
            if (both) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new LoadingMessageEntry(parent.errorHeader, true));
            }
            errors.forEach(e -> this.func_230513_b_((AbstractList.AbstractListEntry)new LoadingMessageEntry((ITextComponent)new StringTextComponent(e.formatToString()))));
            if (both) {
                int maxChars = (this.field_230670_d_ - 10) / ((LoadingErrorScreen)parent).field_230706_i_.field_71466_p.func_78256_a("-");
                this.func_230513_b_((AbstractList.AbstractListEntry)new LoadingMessageEntry((ITextComponent)new StringTextComponent("\n" + Strings.repeat((String)"-", (int)maxChars) + "\n")));
                this.func_230513_b_((AbstractList.AbstractListEntry)new LoadingMessageEntry(parent.warningHeader, true));
            }
            warnings.forEach(w -> this.func_230513_b_((AbstractList.AbstractListEntry)new LoadingMessageEntry((ITextComponent)new StringTextComponent(w.formatToString()))));
        }

        protected int func_230952_d_() {
            return this.getRight() - 6;
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        public class LoadingMessageEntry
        extends ExtendedList.AbstractListEntry<LoadingMessageEntry> {
            private final ITextComponent message;
            private final boolean center;

            LoadingMessageEntry(ITextComponent message) {
                this(message, false);
            }

            LoadingMessageEntry(ITextComponent message, boolean center) {
                this.message = Objects.requireNonNull(message);
                this.center = center;
            }

            public void func_230432_a_(MatrixStack mStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                List strings = font.func_238425_b_((ITextProperties)this.message, LoadingEntryList.this.field_230670_d_);
                int y = top + 2;
                for (int i = 0; i < Math.min(strings.size(), 2); ++i) {
                    if (this.center) {
                        font.func_238422_b_(mStack, (IReorderingProcessor)strings.get(i), (float)(left + LoadingEntryList.this.field_230670_d_) - (float)font.func_243245_a((IReorderingProcessor)strings.get(i)) / 2.0f, (float)y, 0xFFFFFF);
                    } else {
                        font.func_238422_b_(mStack, (IReorderingProcessor)strings.get(i), (float)(left + 5), (float)y, 0xFFFFFF);
                    }
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        }
    }
}

