/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ItemHandlerHelper {
    @Nonnull
    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.func_190926_b() || !a.func_77969_a(b) || a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return (!a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p())) && a.areCapsCompatible((CapabilityProvider)b);
    }

    public static boolean canItemStacksStackRelaxed(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b() || a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (!a.func_77985_e()) {
            return false;
        }
        if (a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return (!a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p())) && a.areCapsCompatible((CapabilityProvider)b);
    }

    @Nonnull
    public static ItemStack copyStackWithSize(@Nonnull ItemStack itemStack, int size) {
        if (size == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = itemStack.func_77946_l();
        copy.func_190920_e(size);
        return copy;
    }

    @Nonnull
    public static ItemStack insertItemStacked(IItemHandler inventory, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack slot;
        int i;
        if (inventory == null || stack.func_190926_b()) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return ItemHandlerHelper.insertItem(inventory, stack, simulate);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; !(i >= sizeInventory || ItemHandlerHelper.canItemStacksStackRelaxed(slot = inventory.getStackInSlot(i), stack) && (stack = inventory.insertItem(i, stack, simulate)).func_190926_b()); ++i) {
        }
        if (!stack.func_190926_b()) {
            for (i = 0; !(i >= sizeInventory || inventory.getStackInSlot(i).func_190926_b() && (stack = inventory.insertItem(i, stack, simulate)).func_190926_b()); ++i) {
            }
        }
        return stack;
    }

    public static void giveItemToPlayer(PlayerEntity player, @Nonnull ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer(player, stack, -1);
    }

    public static void giveItemToPlayer(PlayerEntity player, @Nonnull ItemStack stack, int preferredSlot) {
        if (stack.func_190926_b()) {
            return;
        }
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        World world = player.field_70170_p;
        ItemStack remainder = stack;
        if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        if (!remainder.func_190926_b()) {
            remainder = ItemHandlerHelper.insertItemStacked(inventory, remainder, false);
        }
        if (remainder.func_190926_b() || remainder.func_190916_E() != stack.func_190916_E()) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (!remainder.func_190926_b() && !world.field_72995_K) {
            ItemEntity entityitem = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), remainder);
            entityitem.func_174867_a(40);
            entityitem.func_213317_d(entityitem.func_213322_ci().func_216372_d(0.0, 1.0, 0.0));
            world.func_217376_c((Entity)entityitem);
        }
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        if (inv == null) {
            return 0;
        }
        int itemsFound = 0;
        float proportion = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            proportion += (float)itemstack.func_190916_E() / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++itemsFound;
        }
        return MathHelper.func_76141_d((float)((proportion /= (float)inv.getSlots()) * 14.0f)) + (itemsFound > 0 ? 1 : 0);
    }
}

