/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;

public class DeferredRegister<T extends IForgeRegistryEntry<T>> {
    private final Class<T> superType;
    private final String modid;
    private final Map<RegistryObject<T>, Supplier<? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Supplier<? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    private IForgeRegistry<T> type;
    private Supplier<RegistryBuilder<T>> registryFactory;
    private boolean seenRegisterEvent = false;

    public static <B extends IForgeRegistryEntry<B>> DeferredRegister<B> create(IForgeRegistry<B> reg, String modid) {
        return new DeferredRegister<B>(reg, modid);
    }

    public static <B extends IForgeRegistryEntry<B>> DeferredRegister<B> create(Class<B> base, String modid) {
        return new DeferredRegister<B>(base, modid);
    }

    private DeferredRegister(Class<T> base, String modid) {
        this.superType = base;
        this.modid = modid;
    }

    private DeferredRegister(IForgeRegistry<T> reg, String modid) {
        this(reg.getRegistrySuperType(), modid);
        this.type = reg;
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        RegistryObject ret;
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after RegistryEvent.Register has been fired.");
        }
        Objects.requireNonNull(name);
        Objects.requireNonNull(sup);
        ResourceLocation key = new ResourceLocation(this.modid, name);
        if (this.type != null) {
            ret = RegistryObject.of(key, this.type);
        } else if (this.superType != null) {
            ret = RegistryObject.of(key, this.superType, this.modid);
        } else {
            throw new IllegalStateException("Could not create RegistryObject in DeferredRegister");
        }
        if (this.entries.putIfAbsent(ret, () -> (IForgeRegistryEntry)((IForgeRegistryEntry)sup.get()).setRegistryName(key)) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return ret;
    }

    public Supplier<IForgeRegistry<T>> makeRegistry(String name, Supplier<RegistryBuilder<T>> sup) {
        if (this.superType == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a base type");
        }
        if (this.type != null || this.registryFactory != null) {
            throw new IllegalStateException("Cannot create a registry for a type that already exists");
        }
        this.registryFactory = () -> ((RegistryBuilder)sup.get()).setName(new ResourceLocation(this.modid, name)).setType(this.superType);
        return () -> this.type;
    }

    public void register(IEventBus bus) {
        bus.register((Object)new EventDispatcher(this));
        if (this.type == null && this.registryFactory != null) {
            bus.addListener(this::createRegistry);
        }
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.entriesView;
    }

    private void addEntries(RegistryEvent.Register<?> event) {
        if (this.type == null && this.registryFactory == null) {
            this.captureRegistry();
        }
        if (this.type != null && event.getGenericType() == this.type.getRegistrySuperType()) {
            this.seenRegisterEvent = true;
            IForgeRegistry<?> reg = event.getRegistry();
            for (Map.Entry<RegistryObject<T>, Supplier<T>> e : this.entries.entrySet()) {
                reg.register((IForgeRegistryEntry)e.getValue().get());
                e.getKey().updateReference(reg);
            }
        }
    }

    private void createRegistry(RegistryEvent.NewRegistry event) {
        this.type = this.registryFactory.get().create();
    }

    private void captureRegistry() {
        if (this.superType != null) {
            this.type = RegistryManager.ACTIVE.getRegistry(this.superType);
            if (this.type == null) {
                throw new IllegalStateException("Unable to find registry for type " + this.superType.getName() + " for modid \"" + this.modid + "\" after NewRegistry event");
            }
        } else {
            throw new IllegalStateException("Unable to find registry for mod \"" + this.modid + "\" No lookup criteria specified.");
        }
    }

    public static class EventDispatcher {
        private final DeferredRegister<?> register;

        public EventDispatcher(DeferredRegister<?> register) {
            this.register = register;
        }

        @SubscribeEvent
        public void handleEvent(RegistryEvent.Register<?> event) {
            this.register.addEntries(event);
        }
    }
}

