/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block;

import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;

public class CraftSign
extends CraftBlockEntityState<SignTileEntity>
implements Sign {
    private String[] originalLines = null;
    private String[] lines = null;

    public CraftSign(Block block) {
        super(block, SignTileEntity.class);
    }

    public CraftSign(Material material, SignTileEntity te) {
        super(material, te);
    }

    @Override
    public String[] getLines() {
        if (this.lines == null) {
            SignTileEntity sign = (SignTileEntity)this.getSnapshot();
            this.lines = new String[sign.field_145915_a.length];
            System.arraycopy(CraftSign.revertComponents(sign.field_145915_a), 0, this.lines, 0, this.lines.length);
            this.originalLines = new String[this.lines.length];
            System.arraycopy(this.lines, 0, this.originalLines, 0, this.originalLines.length);
        }
        return this.lines;
    }

    @Override
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.getLines()[index];
    }

    @Override
    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.getLines()[index] = line;
    }

    @Override
    public boolean isEditable() {
        return ((SignTileEntity)this.getSnapshot()).field_145916_j;
    }

    @Override
    public void setEditable(boolean editable) {
        ((SignTileEntity)this.getSnapshot()).field_145916_j = editable;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)((SignTileEntity)this.getSnapshot()).func_214066_f().func_196059_a());
    }

    @Override
    public void setColor(DyeColor color) {
        ((SignTileEntity)this.getSnapshot()).func_214068_a(net.minecraft.item.DyeColor.func_196056_a((int)color.getWoolData()));
    }

    @Override
    public void applyTo(SignTileEntity sign) {
        super.applyTo(sign);
        if (this.lines != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                String line;
                String string = line = this.lines[i] == null ? "" : this.lines[i];
                if (line.equals(this.originalLines[i])) continue;
                sign.field_145915_a[i] = CraftChatMessage.fromString(line)[0];
            }
        }
    }

    public static ITextComponent[] sanitizeLines(String[] lines) {
        ITextComponent[] components = new ITextComponent[4];
        for (int i = 0; i < 4; ++i) {
            components[i] = i < lines.length && lines[i] != null ? CraftChatMessage.fromString(lines[i])[0] : new StringTextComponent("");
        }
        return components;
    }

    public static String[] revertComponents(ITextComponent[] components) {
        String[] lines = new String[components.length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = CraftSign.revertComponent(components[i]);
        }
        return lines;
    }

    private static String revertComponent(ITextComponent component) {
        return CraftChatMessage.fromComponent(component);
    }
}

