/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block.impl;

import net.minecraft.block.BannerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.IntegerProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Rotatable;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;

public final class CraftBanner
extends CraftBlockData
implements Rotatable {
    private static final IntegerProperty ROTATION = CraftBanner.getInteger(BannerBlock.class, "rotation");

    public CraftBanner() {
    }

    public CraftBanner(BlockState state) {
        super(state);
    }

    @Override
    public BlockFace getRotation() {
        int data = (Integer)this.get(ROTATION);
        switch (data) {
            case 0: {
                return BlockFace.SOUTH;
            }
            case 1: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 2: {
                return BlockFace.SOUTH_WEST;
            }
            case 3: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 6: {
                return BlockFace.NORTH_WEST;
            }
            case 7: {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case 8: {
                return BlockFace.NORTH;
            }
            case 9: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 10: {
                return BlockFace.NORTH_EAST;
            }
            case 11: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 12: {
                return BlockFace.EAST;
            }
            case 13: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 14: {
                return BlockFace.SOUTH_EAST;
            }
            case 15: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown rotation " + data);
    }

    @Override
    public void setRotation(BlockFace rotation) {
        int val;
        switch (rotation) {
            case SOUTH: {
                val = 0;
                break;
            }
            case SOUTH_SOUTH_WEST: {
                val = 1;
                break;
            }
            case SOUTH_WEST: {
                val = 2;
                break;
            }
            case WEST_SOUTH_WEST: {
                val = 3;
                break;
            }
            case WEST: {
                val = 4;
                break;
            }
            case WEST_NORTH_WEST: {
                val = 5;
                break;
            }
            case NORTH_WEST: {
                val = 6;
                break;
            }
            case NORTH_NORTH_WEST: {
                val = 7;
                break;
            }
            case NORTH: {
                val = 8;
                break;
            }
            case NORTH_NORTH_EAST: {
                val = 9;
                break;
            }
            case NORTH_EAST: {
                val = 10;
                break;
            }
            case EAST_NORTH_EAST: {
                val = 11;
                break;
            }
            case EAST: {
                val = 12;
                break;
            }
            case EAST_SOUTH_EAST: {
                val = 13;
                break;
            }
            case SOUTH_EAST: {
                val = 14;
                break;
            }
            case SOUTH_SOUTH_EAST: {
                val = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal rotation " + rotation);
            }
        }
        this.set(ROTATION, val);
    }
}

