/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PigEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAnimals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pig;

public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, PigEntity entity) {
        super(server, (AnimalEntity)entity);
    }

    @Override
    public boolean hasSaddle() {
        return this.getHandle().func_110257_ck();
    }

    @Override
    public void setSaddle(boolean saddled) {
        this.getHandle().field_234214_bx_.func_233619_a_(saddled);
    }

    @Override
    public int getBoostTicks() {
        return this.getHandle().field_234214_bx_.field_233610_a_ ? this.getHandle().field_234214_bx_.field_233612_c_ : 0;
    }

    @Override
    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().field_234214_bx_.setBoostTicks(ticks);
    }

    @Override
    public int getCurrentBoostTicks() {
        return this.getHandle().field_234214_bx_.field_233610_a_ ? this.getHandle().field_234214_bx_.field_233611_b_ : 0;
    }

    @Override
    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().field_234214_bx_.field_233610_a_) {
            return;
        }
        int max = this.getHandle().field_234214_bx_.field_233612_c_;
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().field_234214_bx_.field_233611_b_ = ticks;
    }

    @Override
    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    public PigEntity getHandle() {
        return (PigEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPig";
    }

    @Override
    public EntityType getType() {
        return EntityType.PIG;
    }
}

