/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.projectiles;

import java.util.Random;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.potion.CraftPotionUtil;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WitherSkull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final DispenserTileEntity dispenserBlock;

    public CraftBlockProjectileSource(DispenserTileEntity dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    @Override
    public Block getBlock() {
        return this.dispenserBlock.func_145831_w().getWorld().getBlockAt(this.dispenserBlock.func_174877_v().func_177958_n(), this.dispenserBlock.func_174877_v().func_177956_o(), this.dispenserBlock.func_174877_v().func_177952_p());
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Validate.isTrue((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (String)"Block is no longer dispenser");
        ProxyBlockSource isourceblock = new ProxyBlockSource((ServerWorld)this.dispenserBlock.func_145831_w(), this.dispenserBlock.func_174877_v());
        IPosition iposition = DispenserBlock.func_149939_a((IBlockSource)isourceblock);
        Direction enumdirection = (Direction)isourceblock.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
        World world = this.dispenserBlock.func_145831_w();
        Object launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new SnowballEntity(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new EggEntity(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new EnderPearlEntity(world, null);
            launch.func_70107_b(iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new ExperienceBottleEntity(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            if (LingeringPotion.class.isAssignableFrom(projectile)) {
                launch = new PotionEntity(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
                ((PotionEntity)launch).func_213884_b(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
            } else {
                launch = new PotionEntity(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
                ((PotionEntity)launch).func_213884_b(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            }
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new ArrowEntity(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
                ((ArrowEntity)launch).setType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new SpectralArrowEntity(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c()) : new ArrowEntity(world, iposition.func_82615_a(), iposition.func_82617_b(), iposition.func_82616_c());
            }
            ((AbstractArrowEntity)launch).field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            ((AbstractArrowEntity)launch).projectileSource = this;
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            double d0 = iposition.func_82615_a() + (double)((float)enumdirection.func_82601_c() * 0.3f);
            double d1 = iposition.func_82617_b() + (double)((float)enumdirection.func_96559_d() * 0.3f);
            double d2 = iposition.func_82616_c() + (double)((float)enumdirection.func_82599_e() * 0.3f);
            Random random = world.field_73012_v;
            double d3 = random.nextGaussian() * 0.05 + (double)enumdirection.func_82601_c();
            double d4 = random.nextGaussian() * 0.05 + (double)enumdirection.func_96559_d();
            double d5 = random.nextGaussian() * 0.05 + (double)enumdirection.func_82599_e();
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new SmallFireballEntity(world, null, d0, d1, d2);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = EntityType.field_200723_aB.func_200721_a(world);
                launch.func_70107_b(d0, d1, d2);
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                ((DamagingProjectileEntity)launch).field_70232_b = d3 / d6 * 0.1;
                ((DamagingProjectileEntity)launch).field_70233_c = d4 / d6 * 0.1;
                ((DamagingProjectileEntity)launch).field_70230_d = d5 / d6 * 0.1;
            } else {
                launch = EntityType.field_200767_G.func_200721_a(world);
                launch.func_70107_b(d0, d1, d2);
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                ((DamagingProjectileEntity)launch).field_70232_b = d3 / d6 * 0.1;
                ((DamagingProjectileEntity)launch).field_70233_c = d4 / d6 * 0.1;
                ((DamagingProjectileEntity)launch).field_70230_d = d5 / d6 * 0.1;
            }
            ((DamagingProjectileEntity)launch).projectileSource = this;
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported");
        if (launch instanceof ProjectileEntity) {
            if (launch instanceof ThrowableEntity) {
                ((ThrowableEntity)launch).projectileSource = this;
            }
            float a = 6.0f;
            float b = 1.1f;
            if (launch instanceof PotionEntity || launch instanceof ThrownExpBottle) {
                a *= 0.5f;
                b *= 1.25f;
            }
            ((ProjectileEntity)launch).func_70186_c((double)enumdirection.func_82601_c(), (double)((float)enumdirection.func_96559_d() + 0.1f), (double)enumdirection.func_82599_e(), b, a);
        }
        if (velocity != null) {
            ((Projectile)((Object)launch.getBukkitEntity())).setVelocity(velocity);
        }
        world.func_217376_c((Entity)launch);
        return (T)((Projectile)((Object)launch.getBukkitEntity()));
    }
}

