/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_16_R3.util.DummyGeneratorAccess;

public class BlockStateListPopulator
extends DummyGeneratorAccess {
    private final World world;
    private final LinkedHashMap<BlockPos, CraftBlockState> list;

    public BlockStateListPopulator(World world) {
        this(world, new LinkedHashMap<BlockPos, CraftBlockState>());
    }

    public BlockStateListPopulator(World world, LinkedHashMap<BlockPos, CraftBlockState> list) {
        this.world = world;
        this.list = list;
    }

    @Override
    public net.minecraft.block.BlockState func_180495_p(BlockPos bp) {
        CraftBlockState state = this.list.get(bp);
        return state != null ? state.getHandle() : this.world.func_180495_p(bp);
    }

    @Override
    public FluidState func_204610_c(BlockPos bp) {
        CraftBlockState state = this.list.get(bp);
        return state != null ? state.getHandle().func_204520_s() : this.world.func_204610_c(bp);
    }

    public boolean func_180501_a(BlockPos pos, net.minecraft.block.BlockState newState, int flags) {
        this.list.remove(pos);
        CraftBlockState state = CraftBlockState.getBlockState(this.world, pos, flags);
        state.setData(newState);
        this.list.remove(pos);
        this.list.put(pos.func_185334_h(), state);
        return true;
    }

    public void updateList() {
        for (BlockState blockState : this.list.values()) {
            blockState.update(true);
        }
    }

    public Set<BlockPos> getBlocks() {
        return this.list.keySet();
    }

    public List<CraftBlockState> getList() {
        return new ArrayList<CraftBlockState>(this.list.values());
    }

    public World getWorld() {
        return this.world;
    }
}

