/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import com.mohistmc.util.i18n.i18n;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.bukkit.Bukkit;
import org.spigotmc.RestartCommand;

public class WatchdogThread
extends Thread {
    private static WatchdogThread instance;
    private final long timeoutTime;
    private final boolean restart;
    private final long earlyWarningEvery;
    private final long earlyWarningDelay;
    public static volatile boolean hasStarted;
    private long lastEarlyWarning;
    private volatile long lastTick;
    private volatile boolean stopping;

    private WatchdogThread(long timeoutTime, boolean restart) {
        super("Spigot Watchdog Thread");
        this.timeoutTime = timeoutTime;
        this.restart = restart;
        this.earlyWarningEvery = Math.min(5000L, timeoutTime);
        this.earlyWarningDelay = Math.min(10000L, timeoutTime);
    }

    private static long monotonicMillis() {
        return System.nanoTime() / 1000000L;
    }

    public static void doStart(int timeoutTime, boolean restart) {
        if (instance == null) {
            instance = new WatchdogThread((long)timeoutTime * 1000L, restart);
            instance.start();
        }
    }

    public static void tick() {
        WatchdogThread.instance.lastTick = WatchdogThread.monotonicMillis();
    }

    public static void doStop() {
        if (instance != null) {
            WatchdogThread.instance.stopping = true;
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            Logger log = Bukkit.getServer().getLogger();
            long currentTime = WatchdogThread.monotonicMillis();
            if (this.lastTick != 0L && this.timeoutTime > 0L && currentTime > this.lastTick + this.earlyWarningEvery && !Boolean.getBoolean("disable.watchdog")) {
                boolean isLongTimeout;
                boolean bl = isLongTimeout = currentTime > this.lastTick + this.timeoutTime;
                if (!isLongTimeout && (this.earlyWarningEvery <= 0L || !hasStarted || currentTime < this.lastEarlyWarning + this.earlyWarningEvery || currentTime < this.lastTick + this.earlyWarningDelay) || !isLongTimeout && MinecraftServer.getServer().hasStopped()) continue;
                this.lastEarlyWarning = currentTime;
                if (isLongTimeout) {
                    log.log(Level.SEVERE, "------------------------------");
                    log.log(Level.SEVERE, i18n.get((String)"watchdogthread.1"));
                    log.log(Level.SEVERE, i18n.get((String)"watchdogthread.2"));
                    log.log(Level.SEVERE, "\t " + i18n.get((String)"watchdogthread.3"));
                    log.log(Level.SEVERE, i18n.get((String)"watchdogthread.4"));
                    log.log(Level.SEVERE, "\t " + i18n.get((String)"watchdogthread.5"));
                    log.log(Level.SEVERE, i18n.get((String)"watchdogthread.6"));
                    log.log(Level.SEVERE, i18n.get((String)"watchdogthread.7"));
                    log.log(Level.SEVERE, i18n.get((String)"watchdogthread.8") + " " + Bukkit.getServer().getVersion());
                    if (World.lastPhysicsProblem != null) {
                        log.log(Level.SEVERE, "------------------------------");
                        log.log(Level.SEVERE, i18n.get((String)"watchdogthread.9"));
                        log.log(Level.SEVERE, "near " + World.lastPhysicsProblem);
                    }
                } else {
                    log.log(Level.SEVERE, "--- DO NOT REPORT THIS TO PAPER - THIS IS NOT A BUG OR A CRASH  - " + Bukkit.getServer().getVersion() + " ---");
                    log.log(Level.SEVERE, "The server has not responded for " + (currentTime - this.lastTick) / 1000L + " seconds! Creating thread dump");
                }
                log.log(Level.SEVERE, "------------------------------");
                log.log(Level.SEVERE, i18n.get((String)"watchdogthread.10"));
                WatchdogThread.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(MinecraftServer.getServer().field_175590_aa.getId(), Integer.MAX_VALUE), log);
                log.log(Level.SEVERE, "------------------------------");
                if (isLongTimeout) {
                    ThreadInfo[] threads;
                    log.log(Level.SEVERE, i18n.get((String)"watchdogthread.11"));
                    for (ThreadInfo thread : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                        WatchdogThread.dumpThread(thread, log);
                    }
                } else {
                    log.log(Level.SEVERE, "--- DO NOT REPORT THIS TO PAPER - THIS IS NOT A BUG OR A CRASH ---");
                }
                log.log(Level.SEVERE, "------------------------------");
                if (isLongTimeout) {
                    if (!this.restart || MinecraftServer.getServer().hasStopped()) break;
                    RestartCommand.restart();
                    break;
                }
            }
            try {
                WatchdogThread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.interrupt();
            }
        }
    }

    private static void dumpThread(ThreadInfo thread, Logger log) {
        log.log(Level.SEVERE, "------------------------------");
        log.log(Level.SEVERE, i18n.get((String)"watchdogthread.12") + thread.getThreadName());
        log.log(Level.SEVERE, "\tPID: " + thread.getThreadId() + " | " + i18n.get((String)"watchdogthread.13") + thread.isSuspended() + " | " + i18n.get((String)"watchdogthread.14") + thread.isInNative() + " | " + i18n.get((String)"watchdogthread.15") + thread.getThreadState());
        if (thread.getLockedMonitors().length != 0) {
            log.log(Level.SEVERE, "\t" + i18n.get((String)"watchdogthread.16"));
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                log.log(Level.SEVERE, "\t\t" + i18n.get((String)"watchdogthread.17") + monitor.getLockedStackFrame());
            }
        }
        log.log(Level.SEVERE, "\tStack:");
        for (StackTraceElement stack : thread.getStackTrace()) {
            log.log(Level.SEVERE, "\t\t" + (StackTraceElement)stack);
        }
    }
}

