/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariants;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.VerticalEntrance;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.BiomeDictionary;

@MethodsReturnNonnullByDefault
public class BetterMineshaftStructure
extends Structure<NoFeatureConfig> {
    public BetterMineshaftStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long seed, SharedSeedRandom random, int x, int z, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        random.func_202425_c(seed, x, z);
        return random.nextDouble() < (Double)Configuration.mineshaftSpawnRate.get();
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "Better Mineshaft";
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureFeature, int chunkX, int chunkZ, MutableBoundingBox blockBox, int i, long l) {
            super(structureFeature, chunkX, chunkZ, blockBox, i, l);
        }

        @ParametersAreNonnullByDefault
        public void func_230364_a_(DynamicRegistries p_230364_1_, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            Direction direction = Direction.NORTH;
            SharedSeedRandom rand = new SharedSeedRandom();
            rand.func_202422_a(chunkX, chunkZ);
            int r = rand.nextInt(4);
            switch (r) {
                case 0: {
                    direction = Direction.NORTH;
                    break;
                }
                case 1: {
                    direction = Direction.SOUTH;
                    break;
                }
                case 2: {
                    direction = Direction.EAST;
                    break;
                }
                case 3: {
                    direction = Direction.WEST;
                }
            }
            int y = this.field_214631_d.nextInt((Integer)Configuration.maxY.get() - (Integer)Configuration.minY.get() + 1) + (Integer)Configuration.minY.get();
            BlockPos.Mutable startingPos = new BlockPos.Mutable((chunkX << 4) + 2, y, (chunkZ << 4) + 2);
            MineshaftVariantSettings settings = this.getSettingsForBiome(biome);
            VerticalEntrance entryPoint = new VerticalEntrance(-1, (Random)this.field_214631_d, startingPos, direction, settings);
            this.field_75075_a.add(entryPoint);
            ((MineshaftPiece)entryPoint).func_74861_a(entryPoint, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }

        private MineshaftVariantSettings getSettingsForBiome(Biome biome) {
            if (biome.getRegistryName() == null) {
                BetterMineshafts.LOGGER.error("Found null registry name for biome {}. This shouldn't happen!", (Object)biome);
                return MineshaftVariants.get().getDefault();
            }
            RegistryKey registryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
            for (MineshaftVariantSettings variant : MineshaftVariants.get().getVariants()) {
                for (List<BiomeDictionary.Type> tagList : variant.biomeTags) {
                    boolean found = true;
                    for (BiomeDictionary.Type tag : tagList) {
                        if (BiomeDictionary.hasType((RegistryKey)registryKey, (BiomeDictionary.Type)tag)) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    return variant;
                }
            }
            return MineshaftVariants.get().getDefault();
        }
    }
}

