/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator;

import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BigTunnel;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.LayeredIntersection4;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.LayeredIntersection5;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.OreDeposit;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SideRoom;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SideRoomDungeon;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnel;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnelStairs;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.SmallTunnelTurn;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.ZombieVillagerRoom;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public class BetterMineshaftGenerator {
    public static void generateAndAddBigTunnelPiece(StructurePiece structurePiece, List<StructurePiece> list, Random random, int x, int y, int z, Direction direction, int chainLength) {
        if (chainLength > 3) {
            return;
        }
        int rand = random.nextInt(100);
        MineshaftVariantSettings settings = ((MineshaftPiece)structurePiece).getSettings();
        if (rand >= 10 || chainLength < 1) {
            MutableBoundingBox blockBox = BigTunnel.determineBoxPosition(x, y, z, direction);
            BigTunnel newPiece = new BigTunnel(chainLength + 1, random, blockBox, direction, settings);
            list.add(newPiece);
            ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
        }
    }

    public static MineshaftPiece generateAndAddSmallTunnelPiece(StructurePiece structurePiece, List<StructurePiece> list, Random random, int x, int y, int z, Direction direction, int chainLength) {
        int rand = random.nextInt(100);
        MineshaftVariantSettings settings = ((MineshaftPiece)structurePiece).getSettings();
        if (chainLength > (Integer)Configuration.spawnRates.smallShaftPieceChainLength.get() - 2) {
            if (rand < (Integer)Configuration.spawnRates.zombieVillagerRoomSpawnRate.get()) {
                if (direction == Direction.NORTH) {
                    --x;
                } else if (direction == Direction.EAST) {
                    --z;
                } else if (direction == Direction.SOUTH) {
                    ++x;
                } else if (direction == Direction.WEST) {
                    ++z;
                }
                MutableBoundingBox blockBox = ZombieVillagerRoom.determineBoxPosition(list, random, x, y, z, direction);
                if (blockBox != null) {
                    ZombieVillagerRoom newPiece = new ZombieVillagerRoom(chainLength + 1, random, blockBox, direction, settings);
                    list.add(newPiece);
                    ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                    return newPiece;
                }
            } else {
                if (!((Boolean)Configuration.ores.enabled.get()).booleanValue()) {
                    return null;
                }
                MutableBoundingBox blockBox = OreDeposit.determineBoxPosition(list, random, x, y, z, direction);
                if (blockBox != null) {
                    OreDeposit newPiece = new OreDeposit(chainLength + 1, random, blockBox, direction, settings);
                    list.add(newPiece);
                    ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                    return newPiece;
                }
            }
            return null;
        }
        if (rand >= 90 && chainLength > 2 && chainLength < (Integer)Configuration.spawnRates.smallShaftPieceChainLength.get() - 2) {
            MutableBoundingBox blockBox = LayeredIntersection4.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                LayeredIntersection4 newPiece = new LayeredIntersection4(chainLength + 1, random, blockBox, direction, settings);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        } else if (rand >= 80 && chainLength < (Integer)Configuration.spawnRates.smallShaftPieceChainLength.get() - 2) {
            MutableBoundingBox blockBox = SmallTunnelStairs.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                SmallTunnelStairs newPiece = new SmallTunnelStairs(chainLength + 1, random, blockBox, direction, settings);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        } else if (rand >= 70 && chainLength > 2) {
            MutableBoundingBox blockBox = SmallTunnelTurn.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                SmallTunnelTurn newPiece = new SmallTunnelTurn(chainLength + 1, random, blockBox, direction, settings);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        } else if (rand >= 60 && chainLength > 2 && chainLength < (Integer)Configuration.spawnRates.smallShaftPieceChainLength.get() - 2) {
            MutableBoundingBox blockBox = LayeredIntersection5.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                LayeredIntersection5 newPiece = new LayeredIntersection5(chainLength + 1, random, blockBox, direction, settings);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        } else {
            MutableBoundingBox blockBox = SmallTunnel.determineBoxPosition(list, random, x, y, z, direction);
            if (blockBox != null) {
                SmallTunnel newPiece = new SmallTunnel(chainLength + 1, random, blockBox, direction, settings);
                list.add(newPiece);
                ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
                return newPiece;
            }
        }
        return null;
    }

    public static MineshaftPiece generateAndAddSideRoomPiece(StructurePiece structurePiece, List<StructurePiece> list, Random random, int x, int y, int z, Direction direction, int chainLength) {
        MineshaftVariantSettings settings = ((MineshaftPiece)structurePiece).getSettings();
        MutableBoundingBox blockBox = SideRoom.determineBoxPosition(list, random, x, y, z, direction);
        if (blockBox != null) {
            SideRoom newPiece = new SideRoom(chainLength + 1, random, blockBox, direction, settings);
            list.add(newPiece);
            ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
            return newPiece;
        }
        return null;
    }

    public static MineshaftPiece generateAndAddSideRoomDungeonPiece(StructurePiece structurePiece, List<StructurePiece> list, Random random, int x, int y, int z, Direction direction, int chainLength) {
        MineshaftVariantSettings settings = ((MineshaftPiece)structurePiece).getSettings();
        MutableBoundingBox blockBox = SideRoomDungeon.determineBoxPosition(list, random, x, y, z, direction);
        if (blockBox != null) {
            SideRoomDungeon newPiece = new SideRoomDungeon(chainLength + 1, random, blockBox, direction, settings);
            list.add(newPiece);
            ((MineshaftPiece)newPiece).func_74861_a(structurePiece, list, random);
            return newPiece;
        }
        return null;
    }
}

