/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.mixin;

import com.infamous.sapience.mod.IShakesHead;
import com.infamous.sapience.util.AgeableHelper;
import com.infamous.sapience.util.GeneralHelper;
import com.infamous.sapience.util.GreedHelper;
import com.infamous.sapience.util.PiglinReputationType;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReputationHelper;
import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinAction;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinEntity.class})
public abstract class PiglinEntityMixin
extends AbstractPiglinEntity
implements IShakesHead,
IReputationTracking {
    private static final DataParameter<Integer> SHAKE_HEAD_TICKS = EntityDataManager.func_187226_a(PiglinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int NO_TICKS = 40;

    public PiglinEntityMixin(EntityType<? extends AbstractPiglinEntity> entityType, World world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/monster/piglin/PiglinTasks;func_234480_a_(Lnet/minecraft/item/Item;)Z")}, method={"func_234424_eM_"}, cancellable=true)
    private void canPiglinAdmire(CallbackInfoReturnable<PiglinAction> callbackInfoReturnable) {
        boolean isPiglinLoved = PiglinTasksHelper.isPiglinLoved(this.func_184592_cb().func_77973_b());
        boolean isPiglinGreedItem = PiglinTasksHelper.isBarterItem(this.func_184592_cb().func_77973_b());
        if (isPiglinLoved || isPiglinGreedItem) {
            callbackInfoReturnable.setReturnValue((Object)PiglinAction.ADMIRING_ITEM);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"func_234436_k_"}, cancellable=true)
    private void onAddToInventory(ItemStack stack, CallbackInfoReturnable<ItemStack> callbackInfoReturnable) {
        if (PiglinTasksHelper.isBarterItem(stack.func_77973_b())) {
            CompoundNBT compoundNBT = stack.func_196082_o();
            ItemStack remainder = GreedHelper.addGreedItemToGreedInventory((MobEntity)this, stack, compoundNBT.func_74767_n("Bartered"));
            callbackInfoReturnable.setReturnValue((Object)remainder);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"func_230254_b_"}, cancellable=true)
    private void processInteraction(PlayerEntity playerEntity, Hand handIn, CallbackInfoReturnable<ActionResultType> callbackInfoReturnable) {
        ActionResultType actionResultType = (ActionResultType)callbackInfoReturnable.getReturnValue();
        if (!actionResultType.func_226246_a_() && !(actionResultType = PiglinTasksHelper.getGreedActionResultType(this, playerEntity, handIn, actionResultType)).func_226246_a_()) {
            actionResultType = PiglinTasksHelper.getAgeableActionResultType(this, playerEntity, handIn, actionResultType);
        }
        if (!actionResultType.func_226246_a_()) {
            this.setShakeHeadTicks(40);
            this.func_184185_a(SoundEvents.field_232789_kT_, this.func_70599_aP(), this.func_70647_i());
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
        } else {
            this.func_184185_a(SoundEvents.field_232790_kU_, this.func_70599_aP(), this.func_70647_i());
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)8);
            }
        }
        callbackInfoReturnable.setReturnValue((Object)actionResultType);
    }

    @Inject(at={@At(value="HEAD")}, method={"dropSpecialItems"}, cancellable=true)
    private void dropSpecialItems(CallbackInfo callbackInfo) {
        GreedHelper.dropGreedItems((LivingEntity)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"func_234416_a_"}, cancellable=true)
    private void zombify(CallbackInfo callbackInfo) {
        GreedHelper.dropGreedItems((LivingEntity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            GeneralHelper.spawnParticles((LivingEntity)this, (IParticleData)ParticleTypes.field_197633_z);
        } else if (id == 14) {
            GeneralHelper.spawnParticles((LivingEntity)this, (IParticleData)ParticleTypes.field_218420_D);
        } else if (id == 16) {
            GeneralHelper.spawnParticles((LivingEntity)this, (IParticleData)ParticleTypes.field_197609_b);
        } else if (id == 6) {
            GeneralHelper.spawnParticles((LivingEntity)this, (IParticleData)ParticleTypes.field_197601_L);
        } else if (id == 8) {
            GeneralHelper.spawnParticles((LivingEntity)this, (IParticleData)ParticleTypes.field_197632_y);
        } else {
            super.func_70103_a(id);
        }
    }

    public ItemStack func_213357_a(World world, ItemStack itemStack) {
        if (itemStack.func_222117_E()) {
            world.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_213353_d(itemStack), SoundCategory.NEUTRAL, 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
            Item item = itemStack.func_77973_b();
            if (item.func_219967_s() != null) {
                int foodValue = item.func_219967_s().func_221466_a();
                this.func_70691_i(foodValue);
                AgeableHelper.increaseFoodLevel((MobEntity)this, foodValue);
                for (Pair effectAndChancePair : item.func_219967_s().func_221464_f()) {
                    EffectInstance effectInstance = (EffectInstance)effectAndChancePair.getFirst();
                    Float effectChance = (Float)effectAndChancePair.getSecond();
                    if (world.field_72995_K || effectInstance == null || !(world.field_73012_v.nextFloat() < effectChance.floatValue()) || effectInstance.func_188419_a().func_220303_e() == EffectType.HARMFUL && PiglinTasksHelper.isPiglinFoodItem(item)) continue;
                    this.func_195064_c(new EffectInstance(effectInstance));
                }
            }
            itemStack.func_190918_g(1);
            if (!world.field_72995_K) {
                PiglinTasksHelper.setAteRecently(this);
                ReputationHelper.updatePreviousInteractorReputation((MobEntity)this, PiglinReputationType.FOOD_GIFT);
            }
        }
        return itemStack;
    }

    @Inject(at={@At(value="RETURN")}, method={"registerData"})
    private void registerData(CallbackInfo callbackInfo) {
        this.field_70180_af.func_187214_a(SHAKE_HEAD_TICKS, (Object)0);
    }

    @Override
    public int getShakeHeadTicks() {
        return (Integer)this.field_70180_af.func_187225_a(SHAKE_HEAD_TICKS);
    }

    @Override
    public void setShakeHeadTicks(int ticks) {
        this.field_70180_af.func_187227_b(SHAKE_HEAD_TICKS, (Object)ticks);
    }

    public void func_213739_a(IReputationType type, Entity target) {
        ReputationHelper.updatePiglinReputation(this, type, target);
    }

    public void func_233630_a_(ItemEntity itemEntity) {
        super.func_233630_a_(itemEntity);
        if (itemEntity.func_200214_m() != null && this.field_70170_p instanceof ServerWorld) {
            Entity throwerEntity = ((ServerWorld)this.field_70170_p).func_217461_a(itemEntity.func_200214_m());
            ReputationHelper.setPreviousInteractor((MobEntity)this, throwerEntity);
        }
    }
}

