/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.mod;

import com.infamous.sapience.capability.ageable.AgeableProvider;
import com.infamous.sapience.capability.ageable.IAgeable;
import com.infamous.sapience.capability.greed.GreedProvider;
import com.infamous.sapience.capability.reputation.ReputationProvider;
import com.infamous.sapience.mod.IShakesHead;
import com.infamous.sapience.util.AgeableHelper;
import com.infamous.sapience.util.PiglinReputationType;
import com.infamous.sapience.util.PiglinTasksHelper;
import com.infamous.sapience.util.ReputationHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sapience")
public class EventHandler {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PiglinEntity) {
            event.addCapability(new ResourceLocation("sapience", "ageable"), (ICapabilityProvider)new AgeableProvider());
            event.addCapability(new ResourceLocation("sapience", "greed"), (ICapabilityProvider)new GreedProvider());
            event.addCapability(new ResourceLocation("sapience", "reputation"), (ICapabilityProvider)new ReputationProvider());
        }
    }

    @SubscribeEvent
    public static void onPiglinSpawn(EntityJoinWorldEvent event) {
        PiglinEntity piglinEntity;
        if (event.getEntity() instanceof PiglinEntity && !event.getWorld().field_72995_K && (piglinEntity = (PiglinEntity)event.getEntity()).func_70631_g_()) {
            AgeableHelper.initializeChild((MobEntity)piglinEntity);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity murderer = event.getSource().func_76346_g();
        if (event.getEntityLiving() instanceof PiglinEntity && murderer != null && murderer.field_70170_p instanceof ServerWorld) {
            PiglinEntity piglinEntity;
            ReputationHelper.makeWitnessesOfMurder((LivingEntity)piglinEntity, murderer, (piglinEntity = (PiglinEntity)event.getEntityLiving()).func_70631_g_() ? PiglinReputationType.BABY_PIGLIN_KILLED : PiglinReputationType.ADULT_PIGLIN_KILLED);
        } else if (event.getEntityLiving() instanceof PiglinBruteEntity && murderer != null && murderer.field_70170_p instanceof ServerWorld) {
            PiglinBruteEntity bruteEntity = (PiglinBruteEntity)event.getEntityLiving();
            ReputationHelper.makeWitnessesOfMurder((LivingEntity)bruteEntity, murderer, PiglinReputationType.BRUTE_KILLED);
        } else if (event.getEntityLiving() instanceof WitherSkeletonEntity && murderer != null && murderer.field_70170_p instanceof ServerWorld) {
            WitherSkeletonEntity witherSkeletonEntity = (WitherSkeletonEntity)event.getEntityLiving();
            ReputationHelper.makeWitnessesOfMurder((LivingEntity)witherSkeletonEntity, murderer, PiglinReputationType.WITHER_SKELETON_KILLED);
        } else if (event.getEntityLiving() instanceof WitherEntity && murderer != null && murderer.field_70170_p instanceof ServerWorld) {
            WitherEntity witherEntity = (WitherEntity)event.getEntityLiving();
            ReputationHelper.makeWitnessesOfMurder((LivingEntity)witherEntity, murderer, PiglinReputationType.WITHER_KILLED);
        }
    }

    @SubscribeEvent
    public static void onPiglinAttacked(LivingAttackEvent event) {
        Entity attacker = event.getSource().func_76346_g();
        if (event.getEntityLiving() instanceof PiglinEntity && event.getEntityLiving() instanceof IReputationTracking && attacker != null && attacker.field_70170_p instanceof ServerWorld) {
            PiglinEntity piglinEntity = (PiglinEntity)event.getEntityLiving();
            ((ServerWorld)attacker.field_70170_p).func_217489_a(piglinEntity.func_70631_g_() ? PiglinReputationType.BABY_PIGLIN_HURT : PiglinReputationType.ADULT_PIGLIN_HURT, attacker, (IReputationTracking)piglinEntity);
        }
    }

    @SubscribeEvent
    public static void onPiglinUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PiglinEntity) {
            IAgeable ageable;
            IShakesHead shakesHead;
            PiglinEntity piglinEntity = (PiglinEntity)event.getEntityLiving();
            ReputationHelper.updateGossip((MobEntity)piglinEntity);
            if (!(!PiglinTasksHelper.hasConsumableOffhandItem((AbstractPiglinEntity)piglinEntity) || piglinEntity.func_184587_cr() || PiglinTasksHelper.isPiglinFoodItem(piglinEntity.func_184592_cb().func_77973_b()) && PiglinTasksHelper.hasAteRecently((AbstractPiglinEntity)piglinEntity))) {
                piglinEntity.func_184598_c(Hand.OFF_HAND);
            }
            if (piglinEntity instanceof IShakesHead && (shakesHead = (IShakesHead)piglinEntity).getShakeHeadTicks() > 0) {
                shakesHead.setShakeHeadTicks(shakesHead.getShakeHeadTicks() - 1);
            }
            if (!piglinEntity.field_70170_p.field_72995_K && (ageable = AgeableHelper.getAgeableCapability((Entity)piglinEntity)) != null && piglinEntity.func_70089_S()) {
                AgeableHelper.updateSelfAge((MobEntity)piglinEntity);
                AgeableHelper.updateForcedAge((MobEntity)piglinEntity);
                AgeableHelper.updateGrowingAge((MobEntity)piglinEntity);
            }
        }
    }
}

