/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.tasks;

import com.google.common.collect.ImmutableMap;
import com.infamous.sapience.mod.ModMemoryModuleTypes;
import com.infamous.sapience.util.AgeableHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.world.server.ServerWorld;

public class CreateBabyTask<T extends MobEntity>
extends Task<T> {
    private long duration;

    public CreateBabyTask() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()), (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.VALUE_PRESENT), 350, 350);
    }

    protected boolean shouldExecute(ServerWorld worldIn, T owner) {
        return this.canBreed((MobEntity)owner);
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, T entityIn, long gameTimeIn) {
        return gameTimeIn <= this.duration && this.canBreed((MobEntity)entityIn);
    }

    private boolean canBreed(MobEntity owner) {
        Brain brain = owner.func_213375_cj();
        EntityType ownerEntityType = owner.func_200600_R();
        Optional<MobEntity> breedingTarget = brain.func_218207_c((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).filter(breedTarget -> breedTarget.func_200600_R() == ownerEntityType);
        return breedingTarget.filter(partner -> AgeableHelper.canPartnersBreed(owner, partner)).isPresent() && BrainUtil.func_220623_a((Brain)brain, (MemoryModuleType)((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()), (EntityType)ownerEntityType);
    }

    protected void startExecuting(ServerWorld worldIn, T entityIn, long gameTimeIn) {
        if (entityIn.func_213375_cj().func_218207_c((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).isPresent()) {
            MobEntity breedTarget = (MobEntity)entityIn.func_213375_cj().func_218207_c((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).get();
            BrainUtil.func_220618_a(entityIn, (LivingEntity)breedTarget, (float)0.5f);
            worldIn.func_72960_a((Entity)breedTarget, (byte)12);
            worldIn.func_72960_a(entityIn, (byte)12);
            int i = 275 + entityIn.func_70681_au().nextInt(50);
            this.duration = gameTimeIn + (long)i;
        }
    }

    protected void updateTask(ServerWorld worldIn, T owner, long gameTime) {
        MobEntity breedTarget;
        if (owner.func_213375_cj().func_218207_c((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).isPresent() && owner.func_70068_e((Entity)(breedTarget = (MobEntity)owner.func_213375_cj().func_218207_c((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get()).get())) <= 5.0) {
            BrainUtil.func_220618_a(owner, (LivingEntity)breedTarget, (float)0.5f);
            if (gameTime >= this.duration) {
                AgeableHelper.depleteParentsFoodValue(owner, breedTarget);
                this.createChild(worldIn, (MobEntity)owner, breedTarget);
            } else if (owner.func_70681_au().nextInt(35) == 0) {
                worldIn.func_72960_a((Entity)breedTarget, (byte)12);
                worldIn.func_72960_a(owner, (byte)12);
            }
        }
    }

    private void createChild(ServerWorld world, MobEntity parent, MobEntity partner) {
        MobEntity child = AgeableHelper.createChild(world, parent, partner);
        if (child != null) {
            AgeableHelper.setParentsOnBreedCooldown(parent, partner);
            child.func_70012_b(parent.func_226277_ct_(), parent.func_226278_cu_(), parent.func_226281_cx_(), 0.0f, 0.0f);
            world.func_242417_l((Entity)child);
            world.func_72960_a((Entity)child, (byte)12);
        }
    }

    protected void resetTask(ServerWorld worldIn, T entityIn, long gameTimeIn) {
        entityIn.func_213375_cj().func_218189_b((MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get());
    }
}

