/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.Sapience;
import com.infamous.sapience.capability.ageable.AgeableProvider;
import com.infamous.sapience.capability.ageable.IAgeable;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public class AgeableHelper {
    private static final int BIRTH_AGE = -24000;
    private static final int BREEDING_COOLDOWN = 6000;
    public static final int BREEDING_ID = 12;
    public static final int GROWING_ID = 14;

    @Nullable
    public static IAgeable getAgeableCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(AgeableProvider.AGEABLE_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (IAgeable)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the ageable capability from the Entity!"));
        }
        Sapience.LOGGER.error("Couldn't get the ageable capability from " + entity.toString() + "in AgeableHelper#getAgeableCapability!");
        return null;
    }

    public static void depleteParentsFoodValue(MobEntity parent, MobEntity partner) {
        AgeableHelper.depleteFoodValue(parent);
        AgeableHelper.depleteFoodValue(partner);
    }

    private static void depleteFoodValue(MobEntity parent) {
        IAgeable parentAging = AgeableHelper.getAgeableCapability((Entity)parent);
        if (parentAging != null) {
            parentAging.depleteFoodValue();
        }
    }

    static boolean canBreed(MobEntity parent) {
        IAgeable parentAging = AgeableHelper.getAgeableCapability((Entity)parent);
        return parentAging != null && parentAging.canBreed();
    }

    public static boolean canPartnersBreed(MobEntity parent, MobEntity partner) {
        return AgeableHelper.canBreed(parent) && AgeableHelper.canBreed(partner);
    }

    public static void setParentsOnBreedCooldown(MobEntity parent, MobEntity partner) {
        AgeableHelper.setParentOnBreedCooldown(parent);
        AgeableHelper.setParentOnBreedCooldown(partner);
    }

    private static void setParentOnBreedCooldown(MobEntity parent) {
        IAgeable parentAging = AgeableHelper.getAgeableCapability((Entity)parent);
        if (parentAging != null) {
            parentAging.setGrowingAge(6000);
        }
    }

    public static void increaseFoodLevel(MobEntity mobEntity, int foodValueIn) {
        IAgeable ageable = AgeableHelper.getAgeableCapability((Entity)mobEntity);
        if (ageable != null) {
            ageable.increaseFoodLevel(foodValueIn);
        }
    }

    public static void updateGrowingAge(MobEntity mobEntity) {
        IAgeable ageable = AgeableHelper.getAgeableCapability((Entity)mobEntity);
        if (ageable != null) {
            int i = ageable.getGrowingAge();
            if (i < 0) {
                ageable.setGrowingAge(++i);
            } else if (i > 0) {
                ageable.setGrowingAge(--i);
            } else if (mobEntity.func_70631_g_()) {
                mobEntity.func_82227_f(false);
            }
        }
    }

    public static void updateForcedAge(MobEntity mobEntity) {
        IAgeable ageable = AgeableHelper.getAgeableCapability((Entity)mobEntity);
        if (ageable != null && ageable.getForcedAgeTimer() > 0) {
            if (ageable.getForcedAgeTimer() % 4 == 0) {
                mobEntity.field_70170_p.func_72960_a((Entity)mobEntity, (byte)14);
            }
            ageable.setForcedAgeTimer(ageable.getForcedAgeTimer() - 1);
        }
    }

    public static void initializeChild(MobEntity child) {
        IAgeable childAgeable = AgeableHelper.getAgeableCapability((Entity)child);
        if (childAgeable != null && !childAgeable.wasBorn()) {
            childAgeable.setGrowingAge(-24000);
            childAgeable.setBorn(true);
        }
    }

    @Nullable
    public static MobEntity createChild(ServerWorld serverWorld, MobEntity parent, MobEntity partner) {
        MobEntity child;
        EntityType partnerType;
        EntityType parentType = parent.func_200600_R();
        if (parentType == (partnerType = partner.func_200600_R()) && (child = (MobEntity)parentType.func_200721_a((World)serverWorld)) != null) {
            child.func_82227_f(true);
            AgeableHelper.initializeChild(child);
            child.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(child.func_233580_cy_()), SpawnReason.BREEDING, (ILivingEntityData)null, (CompoundNBT)null);
            return child;
        }
        return null;
    }

    public static void updateSelfAge(MobEntity mobEntity) {
        IAgeable ageable = AgeableHelper.getAgeableCapability((Entity)mobEntity);
        if (ageable != null && ageable.canSelfAge()) {
            ageable.depleteFoodValue();
            ageable.ageUp((int)((float)(-ageable.getGrowingAge() / 20) * 0.1f), true);
        }
    }
}

