/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.infamous.sapience.Sapience;
import com.infamous.sapience.SapienceConfig;
import com.infamous.sapience.capability.greed.GreedProvider;
import com.infamous.sapience.capability.greed.IGreed;
import com.infamous.sapience.util.PiglinTasksHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;

public class GreedHelper {
    public static final String BARTERED = "Bartered";

    private static IGreed getGreedCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(GreedProvider.GREED_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (IGreed)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the greed capability from the Entity!"));
        }
        Sapience.LOGGER.error("Couldn't get the greed capability from the Entity in GreedHelper#getAgeableCapability!");
        return null;
    }

    public static boolean doesGreedInventoryHaveGold(MobEntity mobEntity) {
        IGreed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            List forgeIngotsGold = Tags.Items.INGOTS_GOLD.func_230236_b_();
            HashSet goldIngots = new HashSet(forgeIngotsGold);
            return greed.getGreedInventory().func_213902_a(goldIngots);
        }
        return false;
    }

    public static void dropGreedItems(LivingEntity mobEntity) {
        IGreed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            greed.getGreedInventory().func_233543_f_().stream().filter(GreedHelper::wasNotTraded).forEach(arg_0 -> ((LivingEntity)mobEntity).func_199701_a_(arg_0));
        }
    }

    private static boolean wasNotTraded(ItemStack stack) {
        CompoundNBT compoundNBT = stack.func_77978_p();
        return compoundNBT != null && !compoundNBT.func_74767_n(BARTERED);
    }

    public static boolean isSharingGold(MobEntity mobEntity) {
        IGreed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            return greed.isSharingGold();
        }
        return false;
    }

    private static int getIngotRequirement(EquipmentSlotType slotType) {
        switch (slotType) {
            case HEAD: {
                return 5;
            }
            case CHEST: {
                return 8;
            }
            case LEGS: {
                return 7;
            }
            case FEET: {
                return 4;
            }
            case MAINHAND: {
                return 2;
            }
        }
        return 0;
    }

    private static EquipmentSlotType getSlotForItem(Item item) {
        if (item == Items.field_151169_ag) {
            return EquipmentSlotType.HEAD;
        }
        if (item == Items.field_151171_ah) {
            return EquipmentSlotType.CHEST;
        }
        if (item == Items.field_151149_ai) {
            return EquipmentSlotType.LEGS;
        }
        if (item == Items.field_151151_aj) {
            return EquipmentSlotType.FEET;
        }
        if (item == Items.field_151010_B) {
            return EquipmentSlotType.MAINHAND;
        }
        return EquipmentSlotType.OFFHAND;
    }

    private static ItemStack getEquipmentForIngotCount(int ingotCount) {
        switch (ingotCount) {
            case 5: {
                return new ItemStack((IItemProvider)Items.field_151169_ag);
            }
            case 8: {
                return new ItemStack((IItemProvider)Items.field_151171_ah);
            }
            case 7: {
                return new ItemStack((IItemProvider)Items.field_151149_ai);
            }
            case 4: {
                return new ItemStack((IItemProvider)Items.field_151151_aj);
            }
            case 2: {
                return new ItemStack((IItemProvider)Items.field_151010_B);
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack craftArmorFromGreedInventory(MobEntity mobEntity, EquipmentSlotType slotType) {
        IGreed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            int ingotRequirement = GreedHelper.getIngotRequirement(slotType);
            if (ingotRequirement == 0) {
                return ItemStack.field_190927_a;
            }
            int ingotsFound = 0;
            ArrayList<ItemStack> usedStacks = new ArrayList<ItemStack>();
            for (int slotIndex = 0; slotIndex < greed.getGreedInventory().func_70302_i_(); ++slotIndex) {
                ItemStack stackFromSlot = greed.getGreedInventory().func_70301_a(slotIndex);
                if (!stackFromSlot.func_77973_b().func_206844_a((ITag)Tags.Items.INGOTS_GOLD) || stackFromSlot.func_190926_b()) continue;
                for (int i = 1; i <= stackFromSlot.func_190916_E(); ++i) {
                    usedStacks.add(stackFromSlot.func_77979_a(1));
                    if (++ingotsFound != ingotRequirement) continue;
                    ItemStack craftedEquipment = GreedHelper.getEquipmentForIngotCount(ingotsFound);
                    if (craftedEquipment.func_190926_b()) {
                        for (ItemStack itemStack : usedStacks) {
                            greed.getGreedInventory().func_174894_a(itemStack);
                        }
                    }
                    return craftedEquipment;
                }
            }
            for (ItemStack itemStack : usedStacks) {
                greed.getGreedInventory().func_174894_a(itemStack);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public static void checkCraftEquipment(PiglinEntity piglinEntity) {
        IGreed greed = GreedHelper.getGreedCapability((Entity)piglinEntity);
        if (greed != null && !greed.getGreedInventory().func_191420_l()) {
            int heldEquipmentAmount = 0;
            boolean didCraft = false;
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ItemStack craftedEquipment;
                if (slot == EquipmentSlotType.OFFHAND) continue;
                ItemStack stackFromSlot = piglinEntity.func_184582_a(slot);
                if (!stackFromSlot.func_190926_b()) {
                    ItemStack craftedEquipment2;
                    boolean isValidEquipment = (Boolean)SapienceConfig.COMMON.PIGLINS_PREFER_CRAFTED_EQUIPMENT.get() != false ? GreedHelper.isGoldArmorOrWeapon(stackFromSlot) : GreedHelper.isArmorOrWeapon(stackFromSlot);
                    boolean isCrossbow = stackFromSlot.func_222122_m();
                    if (isValidEquipment || isCrossbow) {
                        ++heldEquipmentAmount;
                        continue;
                    }
                    if (didCraft || (craftedEquipment2 = GreedHelper.craftArmorFromGreedInventory((MobEntity)piglinEntity, slot)).func_190926_b()) continue;
                    PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglinEntity)piglinEntity, craftedEquipment2);
                    PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
                    PiglinTasksHelper.clearWalkPath((AbstractPiglinEntity)piglinEntity);
                    didCraft = true;
                    ++heldEquipmentAmount;
                    continue;
                }
                if (didCraft || (craftedEquipment = GreedHelper.craftArmorFromGreedInventory((MobEntity)piglinEntity, slot)).func_190926_b()) continue;
                PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglinEntity)piglinEntity, craftedEquipment);
                PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
                PiglinTasksHelper.clearWalkPath((AbstractPiglinEntity)piglinEntity);
                didCraft = true;
                ++heldEquipmentAmount;
            }
            greed.setSharingGold(heldEquipmentAmount >= 5);
        }
    }

    private static boolean isArmorOrWeapon(ItemStack stack) {
        return stack.func_77973_b() instanceof ArmorItem || stack.func_77973_b() instanceof TieredItem;
    }

    private static boolean isGoldArmorOrWeapon(ItemStack stack) {
        if (stack.func_77973_b() instanceof ArmorItem) {
            return ((ArmorItem)stack.func_77973_b()).func_200880_d() == ArmorMaterial.GOLD;
        }
        if (stack.func_77973_b() instanceof TieredItem) {
            return ((TieredItem)stack.func_77973_b()).func_200891_e() == ItemTier.GOLD;
        }
        return false;
    }

    public static ItemStack addGreedItemToGreedInventory(MobEntity mobEntity, ItemStack stackToAdd, boolean didBarter) {
        IGreed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            if (!stackToAdd.func_190926_b()) {
                Inventory greedInventory = greed.getGreedInventory();
                if (stackToAdd.func_77973_b().func_206844_a((ITag)Tags.Items.INGOTS_GOLD)) {
                    return GreedHelper.addStackToGreedInventoryCheckBartered(mobEntity, stackToAdd, didBarter);
                }
                if (stackToAdd.func_77973_b().func_206844_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)) {
                    int blockCount = stackToAdd.func_190916_E();
                    ItemStack blocksToIngotsStack = new ItemStack((IItemProvider)Items.field_151043_k, blockCount * 9);
                    blocksToIngotsStack.func_77982_d(stackToAdd.func_77978_p());
                    return GreedHelper.addStackToGreedInventoryCheckBartered(mobEntity, blocksToIngotsStack, didBarter);
                }
                if (stackToAdd.func_77973_b().func_206844_a((ITag)Tags.Items.NUGGETS_GOLD)) {
                    return GreedHelper.addGoldNuggetsToGreedInventory(mobEntity, stackToAdd, greedInventory, didBarter);
                }
                return stackToAdd;
            }
            return stackToAdd;
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack addGoldNuggetsToGreedInventory(MobEntity mobEntity, ItemStack stackToAdd, Inventory greedInventory, boolean didBarter) {
        boolean canAutoMerge;
        int nuggetCount = stackToAdd.func_190916_E();
        boolean bl = canAutoMerge = nuggetCount % 9 == 0;
        if (canAutoMerge) {
            ItemStack goldIngotStack = new ItemStack((IItemProvider)Items.field_151043_k, nuggetCount / 9);
            goldIngotStack.func_77982_d(stackToAdd.func_77978_p());
            return GreedHelper.addStackToGreedInventoryCheckBartered(mobEntity, goldIngotStack, didBarter);
        }
        for (int slotIndex = 0; slotIndex < greedInventory.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = greedInventory.func_70301_a(slotIndex);
            if (!stackInSlot.func_77973_b().func_206844_a((ITag)Tags.Items.NUGGETS_GOLD) || stackInSlot.func_190916_E() + nuggetCount > stackInSlot.func_77976_d()) continue;
            stackToAdd.func_190918_g(nuggetCount);
            stackInSlot.func_190917_f(nuggetCount);
            if (stackInSlot.func_190916_E() % 9 == 0) {
                ItemStack goldIngotStack = new ItemStack((IItemProvider)Items.field_151043_k, nuggetCount / 9);
                goldIngotStack.func_77982_d(stackToAdd.func_77978_p());
                greedInventory.func_70299_a(slotIndex, goldIngotStack);
                break;
            }
            if (!stackToAdd.func_190926_b()) continue;
            return stackToAdd;
        }
        return GreedHelper.addStackToGreedInventoryCheckBartered(mobEntity, stackToAdd, didBarter);
    }

    public static ItemStack addStackToGreedInventoryCheckBartered(MobEntity mobEntity, ItemStack stack, boolean didBarter) {
        IGreed greed = GreedHelper.getGreedCapability((Entity)mobEntity);
        if (greed != null) {
            if (didBarter) {
                CompoundNBT compoundNBT = stack.func_196082_o();
                compoundNBT.func_74757_a(BARTERED, true);
            }
            return greed.getGreedInventory().func_174894_a(stack);
        }
        return stack;
    }

    public static Set<Item> getDesiredItems(LivingEntity ally) {
        HashSet<Item> desiredItems = new HashSet<Item>();
        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
            if (slotType == EquipmentSlotType.OFFHAND) continue;
            int ingotRequirement = GreedHelper.getIngotRequirement(slotType);
            ItemStack desiredItemStack = GreedHelper.getEquipmentForIngotCount(ingotRequirement);
            Item desiredItem = desiredItemStack.func_77973_b();
            ItemStack stackFromSlot = ally.func_184582_a(slotType);
            if (!stackFromSlot.func_190926_b()) {
                boolean isValidEquipment;
                boolean isCrossbow = stackFromSlot.func_222122_m();
                boolean bl = isValidEquipment = (Boolean)SapienceConfig.COMMON.PIGLINS_PREFER_CRAFTED_EQUIPMENT.get() != false ? GreedHelper.isGoldArmorOrWeapon(stackFromSlot) : GreedHelper.isArmorOrWeapon(stackFromSlot);
                if (isValidEquipment || isCrossbow || desiredItemStack.func_190926_b()) continue;
                desiredItems.add(desiredItem);
                continue;
            }
            if (desiredItemStack.func_190926_b()) continue;
            desiredItems.add(desiredItem);
        }
        return desiredItems;
    }

    public static void giveAllyDesiredItem(Set<Item> allyDesiredItems, PiglinEntity owner, PiglinEntity ally) {
        if (!allyDesiredItems.isEmpty()) {
            ItemStack craftedItem;
            EquipmentSlotType slotType;
            Item desiredItem = null;
            Iterator<Item> iterator = allyDesiredItems.iterator();
            if (iterator.hasNext()) {
                Item item;
                desiredItem = item = iterator.next();
            }
            if ((slotType = GreedHelper.getSlotForItem(desiredItem)) != EquipmentSlotType.OFFHAND && !(craftedItem = GreedHelper.craftArmorFromGreedInventory((MobEntity)owner, slotType)).func_190926_b()) {
                GreedHelper.checkCraftEquipment(owner);
                owner.func_184609_a(Hand.OFF_HAND);
                PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand((AbstractPiglinEntity)ally, craftedItem);
                PiglinTasksHelper.setAdmiringItem((LivingEntity)ally);
                PiglinTasksHelper.clearWalkPath((AbstractPiglinEntity)ally);
                ally.field_70170_p.func_72960_a((Entity)ally, (byte)8);
                allyDesiredItems.remove(desiredItem);
            }
        }
    }
}

