/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.google.common.collect.ImmutableList;
import com.infamous.sapience.mod.ModMemoryModuleTypes;
import com.infamous.sapience.tasks.CraftWithGoldTask;
import com.infamous.sapience.tasks.CreateBabyTask;
import com.infamous.sapience.tasks.FeedHoglinsTask;
import com.infamous.sapience.tasks.ShareGoldTask;
import com.infamous.sapience.util.AgeableHelper;
import com.infamous.sapience.util.ReputationHelper;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinAction;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;

public class PiglinTasksHelper {
    private static final Tags.IOptionalNamedTag<Item> PIGLIN_FOOD_ITEMS = ItemTags.createOptional((ResourceLocation)new ResourceLocation("sapience", "piglin_food_items"));
    private static final ResourceLocation PIGLIN_BARTERING_CHEAP = new ResourceLocation("sapience", "gameplay/piglin_bartering_cheap");
    private static final ResourceLocation PIGLIN_BARTERING_EXPENSIVE = new ResourceLocation("sapience", "gameplay/piglin_bartering_expensive");
    private static final RangedInteger RANGED_FEEDING_TIMER = TickRangeConverter.func_233037_a_((int)30, (int)120);

    public static boolean canPickUpFoodStack(PiglinEntity piglinEntity, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item.func_206844_a((ITag)ItemTags.field_232902_M_)) {
            return false;
        }
        if (PiglinTasksHelper.hasAdmiringDisabled((AbstractPiglinEntity)piglinEntity) && piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_)) {
            return false;
        }
        if (itemStack.isPiglinCurrency()) {
            return PiglinTasksHelper.hasOpenOffhandSlot(piglinEntity);
        }
        if (PiglinTasksHelper.isPiglinFoodItem(item)) {
            return !PiglinTasksHelper.hasAteRecently((AbstractPiglinEntity)piglinEntity) && PiglinTasksHelper.hasOpenOffhandSlot(piglinEntity);
        }
        return false;
    }

    private static void dropItems(AbstractPiglinEntity piglinEntity, List<ItemStack> itemStacks, Vector3d vector3d) {
        if (!itemStacks.isEmpty()) {
            piglinEntity.func_184609_a(Hand.OFF_HAND);
            for (ItemStack itemstack : itemStacks) {
                BrainUtil.func_233865_a_((LivingEntity)piglinEntity, (ItemStack)itemstack, (Vector3d)vector3d.func_72441_c(0.0, 1.0, 0.0));
            }
        }
    }

    private static Vector3d getNearbyVectorOrPositionVector(AbstractPiglinEntity piglinEntity) {
        Vector3d vector3d = RandomPositionGenerator.func_191377_b((CreatureEntity)piglinEntity, (int)4, (int)2);
        return vector3d == null ? piglinEntity.func_213303_ch() : vector3d;
    }

    private static void dropItemsNearSelf(AbstractPiglinEntity piglinEntity, List<ItemStack> itemStacks) {
        PiglinTasksHelper.dropItems(piglinEntity, itemStacks, PiglinTasksHelper.getNearbyVectorOrPositionVector(piglinEntity));
    }

    public static void setAteRecently(AbstractPiglinEntity piglinEntity) {
        piglinEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234097_ae_, (Object)true, 200L);
    }

    public static ItemStack extractSingletonFromItemEntity(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        ItemStack itemstack1 = itemstack.func_77979_a(1);
        if (itemstack.func_190926_b()) {
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(itemstack);
        }
        return itemstack1;
    }

    public static boolean isPiglinFoodItem(Item item) {
        return item.func_206844_a(PIGLIN_FOOD_ITEMS) && item.func_219971_r();
    }

    public static boolean hasAteRecently(AbstractPiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234097_ae_);
    }

    public static boolean hasOpenOffhandSlot(PiglinEntity piglinEntity) {
        return piglinEntity.func_184592_cb().func_190926_b() || !PiglinTasksHelper.isPiglinLoved(piglinEntity.func_184592_cb().func_77973_b());
    }

    public static boolean isPiglinLoved(Item item) {
        return item.func_206844_a((ITag)ItemTags.field_232903_N_);
    }

    private static boolean hasAdmiringDisabled(AbstractPiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234081_O_);
    }

    public static ImmutableList getInteractionTasks() {
        return ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(0.6f), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a((EntityType)EntityType.field_233591_ai_, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)new SupplementedTask(PiglinTasksHelper::doesNotHaveNearestPlayerHoldingWantedItem, (Task)new WalkTowardsLookTargetTask(0.6f, 3)), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1), (Object)Pair.of((Object)new InteractWithEntityTask(EntityType.field_233591_ai_, 8, AgeableHelper::canBreed, AgeableHelper::canBreed, (MemoryModuleType)ModMemoryModuleTypes.BREEDING_TARGET.get(), 0.5f, 2), (Object)1), (Object)Pair.of(new CreateBabyTask(), (Object)3), (Object)Pair.of(new ShareGoldTask(), (Object)2), (Object)Pair.of(new CraftWithGoldTask(), (Object)2), (Object)Pair.of(new FeedHoglinsTask(), (Object)2));
    }

    public static boolean hasNearbyBabyHoglin(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234086_T_);
    }

    public static boolean hasHuntedRecently(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234082_P_);
    }

    public static boolean hasNotFedRecently(PiglinEntity piglinEntity) {
        return !PiglinTasksHelper.hasFedRecently(piglinEntity);
    }

    public static void setFedRecently(PiglinEntity piglinEntity) {
        piglinEntity.func_213375_cj().func_233696_a_((MemoryModuleType)ModMemoryModuleTypes.FED_RECENTLY.get(), (Object)true, (long)RANGED_FEEDING_TIMER.func_233018_a_(piglinEntity.field_70170_p.field_73012_v));
    }

    private static boolean hasFedRecently(PiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a((MemoryModuleType)ModMemoryModuleTypes.FED_RECENTLY.get());
    }

    public static boolean outnumbersHoglins(PiglinEntity piglinEntity) {
        return !PiglinTasksHelper.isOutnumberedByHoglins(piglinEntity);
    }

    private static boolean isOutnumberedByHoglins(PiglinEntity piglinEntity) {
        int piglinCount = piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234094_ab_).orElse(0) + 1;
        int hoglinCount = piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234095_ac_).orElse(0);
        return hoglinCount > piglinCount;
    }

    private static boolean hasNearestPlayerHoldingWantedItem(LivingEntity livingEntity) {
        return livingEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234096_ad_);
    }

    private static boolean doesNotHaveNearestPlayerHoldingWantedItem(LivingEntity livingEntity) {
        return !PiglinTasksHelper.hasNearestPlayerHoldingWantedItem(livingEntity);
    }

    public static void removeTimeTryingToReachAdmireItem(PiglinEntity piglinEntity) {
        piglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_242310_O);
    }

    public static void dropOffhandItemAndSetItemStackToOffhand(AbstractPiglinEntity piglinEntity, ItemStack itemStack) {
        if (PiglinTasksHelper.hasOffhandItem(piglinEntity)) {
            piglinEntity.func_199701_a_(piglinEntity.func_184586_b(Hand.OFF_HAND));
        }
        PiglinTasksHelper.setItemStackToOffhandAndPersist(piglinEntity, itemStack);
    }

    private static boolean hasOffhandItem(AbstractPiglinEntity piglinEntity) {
        return !piglinEntity.func_184592_cb().func_190926_b();
    }

    private static void setItemStackToOffhandAndPersist(AbstractPiglinEntity piglinEntity, ItemStack itemStack) {
        piglinEntity.func_184201_a(EquipmentSlotType.OFFHAND, itemStack);
        piglinEntity.func_233663_d_(EquipmentSlotType.OFFHAND);
        piglinEntity.func_110163_bv();
    }

    public static void clearWalkPath(AbstractPiglinEntity piglinEntity) {
        piglinEntity.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        piglinEntity.func_70661_as().func_75499_g();
    }

    public static boolean hasConsumableOffhandItem(AbstractPiglinEntity piglinEntity) {
        ItemStack offhandStack = piglinEntity.func_184592_cb();
        return PiglinTasksHelper.isPiglinFoodItem(offhandStack.func_77973_b()) || offhandStack.func_77975_n() == UseAction.DRINK;
    }

    public static void setAdmiringItem(LivingEntity livingEntity) {
        livingEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234080_N_, (Object)true, 120L);
    }

    private static boolean hasAdmiringItem(AbstractPiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234080_N_);
    }

    public static boolean isNormalBarterItem(Item item) {
        return item.func_206844_a((ITag)Tags.Items.INGOTS_GOLD);
    }

    public static boolean isBarterItem(Item item) {
        return PiglinTasksHelper.isNormalBarterItem(item) || PiglinTasksHelper.isAlternativeGreedItem(item);
    }

    private static boolean isAlternativeGreedItem(Item item) {
        return PiglinTasksHelper.isExpensiveBarterItem(item) || PiglinTasksHelper.isCheapBarterItem(item);
    }

    private static ActionResultType processInteractionForFoodItem(AbstractPiglinEntity piglinEntity, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemstack = playerEntity.func_184586_b(hand);
        if (PiglinTasksHelper.canAcceptFoodItem(piglinEntity, itemstack)) {
            ItemStack foodStack = itemstack.func_77979_a(1);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand(piglinEntity, foodStack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
            PiglinTasksHelper.clearWalkPath(piglinEntity);
            ReputationHelper.setPreviousInteractor((MobEntity)piglinEntity, (Entity)playerEntity);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType processInteractionForPiglinGreedItem(AbstractPiglinEntity piglinEntity, PlayerEntity playerEntity, Hand handIn) {
        ItemStack itemstack = playerEntity.func_184586_b(handIn);
        if (PiglinTasksHelper.canAcceptPiglinGreedItem(piglinEntity, itemstack)) {
            ItemStack greedStack = itemstack.func_77979_a(1);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand(piglinEntity, greedStack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
            PiglinTasksHelper.clearWalkPath(piglinEntity);
            ReputationHelper.setPreviousInteractor((MobEntity)piglinEntity, (Entity)playerEntity);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType processInteractionForPiglinLovedItem(AbstractPiglinEntity piglinEntity, PlayerEntity playerEntity, Hand handIn) {
        ItemStack itemstack = playerEntity.func_184586_b(handIn);
        if (PiglinTasksHelper.canAcceptPiglinLovedItem(piglinEntity, itemstack)) {
            ItemStack greedStack = itemstack.func_77979_a(1);
            PiglinTasksHelper.dropOffhandItemAndSetItemStackToOffhand(piglinEntity, greedStack);
            PiglinTasksHelper.setAdmiringItem((LivingEntity)piglinEntity);
            PiglinTasksHelper.clearWalkPath(piglinEntity);
            ReputationHelper.setPreviousInteractor((MobEntity)piglinEntity, (Entity)playerEntity);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    private static boolean canAcceptPiglinGreedItem(AbstractPiglinEntity piglinEntity, ItemStack itemStack) {
        return !PiglinTasksHelper.hasAdmiringDisabled(piglinEntity) && !PiglinTasksHelper.hasAdmiringItem(piglinEntity) && (PiglinTasksHelper.isAlternativeGreedItem(itemStack.func_77973_b()) || PiglinTasksHelper.isNormalBarterItem(itemStack.func_77973_b()) && piglinEntity.func_70631_g_()) && !PiglinTasksHelper.hasConsumableOffhandItem(piglinEntity);
    }

    private static boolean canAcceptPiglinLovedItem(AbstractPiglinEntity piglinEntity, ItemStack itemStack) {
        return !PiglinTasksHelper.hasAdmiringDisabled(piglinEntity) && !PiglinTasksHelper.hasAdmiringItem(piglinEntity) && PiglinTasksHelper.isPiglinLoved(itemStack.func_77973_b()) && !PiglinTasksHelper.hasConsumableOffhandItem(piglinEntity);
    }

    private static boolean canAcceptFoodItem(AbstractPiglinEntity piglinEntity, ItemStack itemStack) {
        return !PiglinTasksHelper.hasAdmiringDisabled(piglinEntity) && !PiglinTasksHelper.hasAdmiringItem(piglinEntity) && PiglinTasksHelper.isPiglinFoodItem(itemStack.func_77973_b()) && !PiglinTasksHelper.hasAteRecently(piglinEntity) && !piglinEntity.func_213398_dR() && !PiglinTasksHelper.hasConsumableOffhandItem(piglinEntity);
    }

    public static ActionResultType getAgeableActionResultType(AbstractPiglinEntity piglinEntity, PlayerEntity playerEntity, Hand handIn, ActionResultType actionResultTypeIn) {
        ItemStack itemStack = playerEntity.func_184586_b(handIn);
        if (PiglinTasksHelper.isPiglinFoodItem(itemStack.func_77973_b())) {
            if (!piglinEntity.field_70170_p.field_72995_K) {
                actionResultTypeIn = PiglinTasksHelper.processInteractionForFoodItem(piglinEntity, playerEntity, handIn);
            } else {
                boolean canAcceptFoodItem = PiglinTasksHelper.canAcceptFoodItem(piglinEntity, itemStack) && piglinEntity.func_234424_eM_() != PiglinAction.ADMIRING_ITEM;
                actionResultTypeIn = canAcceptFoodItem ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
        }
        return actionResultTypeIn;
    }

    public static ActionResultType getGreedActionResultType(AbstractPiglinEntity piglinEntity, PlayerEntity playerEntity, Hand handIn, ActionResultType actionResultTypeIn) {
        ItemStack itemStack = playerEntity.func_184586_b(handIn);
        if (PiglinTasksHelper.isBarterItem(itemStack.func_77973_b())) {
            if (!piglinEntity.field_70170_p.field_72995_K) {
                actionResultTypeIn = PiglinTasksHelper.processInteractionForPiglinGreedItem(piglinEntity, playerEntity, handIn);
            } else {
                boolean canTakeGreedItem = PiglinTasksHelper.canAcceptPiglinGreedItem(piglinEntity, itemStack) && piglinEntity.func_234424_eM_() != PiglinAction.ADMIRING_ITEM;
                actionResultTypeIn = canTakeGreedItem ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
        } else if (PiglinTasksHelper.isPiglinLoved(itemStack.func_77973_b())) {
            if (!piglinEntity.field_70170_p.field_72995_K) {
                actionResultTypeIn = PiglinTasksHelper.processInteractionForPiglinLovedItem(piglinEntity, playerEntity, handIn);
            } else {
                boolean canTakeLovedItem = PiglinTasksHelper.canAcceptPiglinLovedItem(piglinEntity, itemStack) && piglinEntity.func_234424_eM_() != PiglinAction.ADMIRING_ITEM;
                actionResultTypeIn = canTakeLovedItem ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
        }
        return actionResultTypeIn;
    }

    private static List<ItemStack> getBlockBarteringLoot(AbstractPiglinEntity piglinEntity) {
        if (piglinEntity.field_70170_p.func_73046_m() != null) {
            LootTable loottable = piglinEntity.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(PIGLIN_BARTERING_EXPENSIVE);
            return loottable.func_216113_a(new LootContext.Builder((ServerWorld)piglinEntity.field_70170_p).func_216015_a(LootParameters.field_216281_a, (Object)piglinEntity).func_216023_a(piglinEntity.field_70170_p.field_73012_v).func_216022_a(LootParameterSets.field_237453_h_));
        }
        return Collections.emptyList();
    }

    private static List<ItemStack> getNuggetBarteringLoot(AbstractPiglinEntity piglinEntity) {
        if (piglinEntity.field_70170_p.func_73046_m() != null) {
            LootTable loottable = piglinEntity.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(PIGLIN_BARTERING_CHEAP);
            return loottable.func_216113_a(new LootContext.Builder((ServerWorld)piglinEntity.field_70170_p).func_216015_a(LootParameters.field_216281_a, (Object)piglinEntity).func_216023_a(piglinEntity.field_70170_p.field_73012_v).func_216022_a(LootParameterSets.field_237453_h_));
        }
        return Collections.emptyList();
    }

    public static boolean isExpensiveBarterItem(Item item) {
        return item.func_206844_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD);
    }

    public static boolean isCheapBarterItem(Item item) {
        return item.func_206844_a((ITag)Tags.Items.NUGGETS_GOLD);
    }

    public static void dropBlockBarteringLoot(AbstractPiglinEntity piglinEntity) {
        PiglinTasksHelper.dropItemsAccountingForNearbyPlayer(piglinEntity, PiglinTasksHelper.getBlockBarteringLoot(piglinEntity));
    }

    public static void dropNuggetBarteringLoot(AbstractPiglinEntity piglinEntity) {
        PiglinTasksHelper.dropItemsAccountingForNearbyPlayer(piglinEntity, PiglinTasksHelper.getNuggetBarteringLoot(piglinEntity));
    }

    private static void dropItemsAccountingForNearbyPlayer(AbstractPiglinEntity piglinEntity, List<ItemStack> itemStacks) {
        Optional<PlayerEntity> optionalPlayerEntity = PiglinTasksHelper.getNearestVisiblePlayer(piglinEntity);
        if (optionalPlayerEntity.isPresent()) {
            PiglinTasksHelper.dropItemsNearPlayer(piglinEntity, optionalPlayerEntity.get(), itemStacks);
        } else {
            PiglinTasksHelper.dropItemsNearSelf(piglinEntity, itemStacks);
        }
    }

    private static Optional<PlayerEntity> getNearestVisiblePlayer(AbstractPiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220949_j);
    }

    private static void dropItemsNearPlayer(AbstractPiglinEntity piglinEntity, PlayerEntity playerEntity, List<ItemStack> itemStacks) {
        PiglinTasksHelper.dropItems(piglinEntity, itemStacks, playerEntity.func_213303_ch());
    }

    public static boolean canTarget(LivingEntity livingEntity) {
        return EntityPredicates.field_233583_f_.test(livingEntity);
    }

    private static Optional<LivingEntity> getAngerTargetFromMemory(AbstractPiglinEntity piglinEntity) {
        return BrainUtil.func_233864_a_((LivingEntity)piglinEntity, (MemoryModuleType)MemoryModuleType.field_234078_L_);
    }

    public static boolean hasIdle(AbstractPiglinEntity piglinEntity) {
        return piglinEntity.func_213375_cj().func_218214_c(Activity.field_221366_b);
    }
}

