/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete;

import com.google.common.io.Files;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Test {
    public static void main(String[] args) {
        ArrayList<String> pathsFinal = new ArrayList<String>();
        pathsFinal.add("config/mypath/12.png");
        pathsFinal.add("config/mypath/23.png");
        pathsFinal.add("config/mypath/43.png");
        pathsFinal.add("config/mypath/65.png");
        pathsFinal.add("config/mypath/39.png");
        for (int i = 1; i < 300; ++i) {
            pathsFinal.add("config/mypath/" + i + ".png");
        }
        pathsFinal.add("config/mypath/sisri.png");
        pathsFinal.add("config/mypath/aisri.png");
        final CharacterFilter c = CharacterFilter.getIntegerCharacterFiler();
        ArrayList<String> nonNumberNames = new ArrayList<String>();
        ArrayList<String> numberNames = new ArrayList<String>();
        for (String s : pathsFinal) {
            String name = Files.getNameWithoutExtension((String)s);
            if (name == null) continue;
            String digit = c.filterForAllowedChars(name);
            if (!digit.equals("")) {
                System.out.println("NUMBER NAME: " + s + " | basename: " + name + " | digit: " + digit);
                numberNames.add(s);
                continue;
            }
            System.out.println("NON-NUMBER NAME: " + s + " | basename: " + name + " | digit: " + digit);
            nonNumberNames.add(s);
        }
        Collections.sort(nonNumberNames, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(numberNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String s1 = Files.getNameWithoutExtension((String)o1);
                String s2 = Files.getNameWithoutExtension((String)o2);
                if (s1 != null && s2 != null) {
                    String n1 = c.filterForAllowedChars(s1);
                    String n2 = c.filterForAllowedChars(s2);
                    if (MathUtils.isInteger(n1) && MathUtils.isInteger(n2)) {
                        int i2;
                        int i1 = Integer.parseInt(n1);
                        if (i1 > (i2 = Integer.parseInt(n2))) {
                            return 1;
                        }
                        if (i1 < i2) {
                            return -1;
                        }
                        return 0;
                    }
                }
                return 0;
            }
        });
        for (String s : nonNumberNames) {
            System.out.println("NON-NUMBER FINAL: " + s);
        }
        for (String s : numberNames) {
            System.out.println("NUMBER FINAL: " + s);
        }
    }
}

