/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.gui.content.AdvancedButtonHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class AdvancedButton
extends Button {
    private boolean handleClick = false;
    private static boolean leftDown = false;
    private boolean leftDownThis = false;
    private boolean leftDownNotHovered = false;
    public boolean ignoreBlockedInput = false;
    public boolean ignoreLeftMouseDownClickBlock = false;
    public boolean enableRightclick = false;
    public float labelScale = 1.0f;
    private boolean useable = true;
    private boolean labelShadow = true;
    private Color idleColor;
    private Color hoveredColor;
    private Color idleBorderColor;
    private Color hoveredBorderColor;
    private float borderWidth = 2.0f;
    private ResourceLocation backgroundHover;
    private ResourceLocation backgroundNormal;
    String clicksound = null;
    String[] description = null;
    private Button.IPressable press;

    public AdvancedButton(int x, int y, int widthIn, int heightIn, String buttonText, Button.IPressable onPress) {
        super(x, y, widthIn, heightIn, (ITextComponent)new StringTextComponent(buttonText), onPress);
        this.press = onPress;
    }

    public AdvancedButton(int x, int y, int widthIn, int heightIn, String buttonText, boolean handleClick, Button.IPressable onPress) {
        super(x, y, widthIn, heightIn, (ITextComponent)new StringTextComponent(buttonText), onPress);
        this.handleClick = handleClick;
        this.press = onPress;
    }

    public void func_230930_b_() {
        this.press.onPress((Button)this);
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            Minecraft mc = Minecraft.func_71410_x();
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            RenderSystem.enableBlend();
            if (this.hasColorBackground()) {
                Color border;
                if (!this.field_230692_n_) {
                    AdvancedButton.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)(this.idleColor.getRGB() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
                    border = this.idleBorderColor;
                } else if (this.field_230693_o_) {
                    AdvancedButton.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)(this.hoveredColor.getRGB() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
                    border = this.hoveredBorderColor;
                } else {
                    AdvancedButton.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)(this.idleColor.getRGB() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
                    border = this.idleBorderColor;
                }
                if (this.hasBorder()) {
                    RenderUtils.fill(matrix, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, (float)this.field_230691_m_ + this.borderWidth, border.getRGB(), this.field_230695_q_);
                    RenderUtils.fill(matrix, this.field_230690_l_, (float)(this.field_230691_m_ + this.field_230689_k_) - this.borderWidth, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, border.getRGB(), this.field_230695_q_);
                    RenderUtils.fill(matrix, this.field_230690_l_, (float)this.field_230691_m_ + this.borderWidth, (float)this.field_230690_l_ + this.borderWidth, (float)(this.field_230691_m_ + this.field_230689_k_) - this.borderWidth, border.getRGB(), this.field_230695_q_);
                    RenderUtils.fill(matrix, (float)(this.field_230690_l_ + this.field_230688_j_) - this.borderWidth, (float)this.field_230691_m_ + this.borderWidth, this.field_230690_l_ + this.field_230688_j_, (float)(this.field_230691_m_ + this.field_230689_k_) - this.borderWidth, border.getRGB(), this.field_230695_q_);
                }
            } else if (this.hasCustomTextureBackground()) {
                if (this.func_230449_g_()) {
                    if (this.field_230693_o_) {
                        mc.field_71446_o.func_110577_a(this.backgroundHover);
                    } else {
                        mc.field_71446_o.func_110577_a(this.backgroundNormal);
                    }
                } else {
                    mc.field_71446_o.func_110577_a(this.backgroundNormal);
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
                AdvancedButton.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.field_230688_j_, (int)this.field_230689_k_);
            } else {
                mc.func_110434_K().func_110577_a(field_230687_i_);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
                int i = this.func_230989_a_(this.func_230449_g_());
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, 0, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
                this.func_238474_b_(matrix, this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_, 200 - this.field_230688_j_ / 2, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
                RenderSystem.disableDepthTest();
            }
            this.func_230441_a_(matrix, mc, mouseX, mouseY);
            this.renderLabel(matrix);
            if (this.func_230449_g_()) {
                AdvancedButtonHandler.setActiveDescriptionButton(this);
            }
        }
        if (!this.func_230449_g_() && MouseInput.isLeftMouseDown()) {
            this.leftDownNotHovered = true;
        }
        if (!MouseInput.isLeftMouseDown()) {
            this.leftDownNotHovered = false;
        }
        if (this.handleClick && this.useable) {
            if (this.func_230449_g_() && (MouseInput.isLeftMouseDown() || this.enableRightclick && MouseInput.isRightMouseDown()) && (!leftDown || this.ignoreLeftMouseDownClickBlock) && !this.leftDownNotHovered && !this.isInputBlocked() && this.field_230693_o_ && this.field_230694_p_ && !this.leftDownThis) {
                this.func_230982_a_(mouseX, mouseY);
                if (this.clicksound == null) {
                    this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                } else {
                    SoundHandler.resetSound(this.clicksound);
                    SoundHandler.playSound(this.clicksound);
                }
                leftDown = true;
                this.leftDownThis = true;
            }
            if (!(MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown() && this.enableRightclick)) {
                leftDown = false;
                this.leftDownThis = false;
            }
        }
    }

    protected void renderLabel(MatrixStack matrix) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = font.func_78256_a(this.getMessageString());
        int stringHeight = 8;
        int pX = (int)(((float)(this.field_230690_l_ + this.field_230688_j_ / 2) - (float)stringWidth * this.labelScale / 2.0f) / this.labelScale);
        int pY = (int)(((float)(this.field_230691_m_ + this.field_230689_k_ / 2) - (float)stringHeight * this.labelScale / 2.0f) / this.labelScale);
        matrix.func_227860_a_();
        matrix.func_227862_a_(this.labelScale, this.labelScale, this.labelScale);
        if (this.labelShadow) {
            font.func_238405_a_(matrix, this.getMessageString(), (float)pX, (float)pY, this.getFGColor() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24);
        } else {
            font.func_238421_b_(matrix, this.getMessageString(), (float)pX, (float)pY, this.getFGColor() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24);
        }
        matrix.func_227865_b_();
    }

    private boolean isInputBlocked() {
        if (this.ignoreBlockedInput) {
            return false;
        }
        return MouseInput.isVanillaInputBlocked();
    }

    public void setBackgroundColor(@Nullable Color idle, @Nullable Color hovered, @Nullable Color idleBorder, @Nullable Color hoveredBorder, float borderWidth) {
        this.idleColor = idle;
        this.hoveredColor = hovered;
        this.hoveredBorderColor = hoveredBorder;
        this.idleBorderColor = idleBorder;
        if (borderWidth >= 0.0f) {
            this.borderWidth = borderWidth;
        } else {
            borderWidth = 0.0f;
        }
    }

    public void setBackgroundColor(@Nullable Color idle, @Nullable Color hovered, @Nullable Color idleBorder, @Nullable Color hoveredBorder, int borderWidth) {
        this.setBackgroundColor(idle, hovered, idleBorder, hoveredBorder, (float)borderWidth);
    }

    public void setBackgroundTexture(ResourceLocation normal, ResourceLocation hovered) {
        this.backgroundNormal = normal;
        this.backgroundHover = hovered;
    }

    public void setBackgroundTexture(ExternalTextureResourceLocation normal, ExternalTextureResourceLocation hovered) {
        if (!normal.isReady()) {
            normal.loadTexture();
        }
        if (!hovered.isReady()) {
            hovered.loadTexture();
        }
        this.backgroundHover = hovered.getResourceLocation();
        this.backgroundNormal = normal.getResourceLocation();
    }

    public boolean hasBorder() {
        return this.hasColorBackground() && this.idleBorderColor != null && this.hoveredBorderColor != null;
    }

    public boolean hasColorBackground() {
        return this.idleColor != null && this.hoveredColor != null;
    }

    public boolean hasCustomTextureBackground() {
        return this.backgroundHover != null && this.backgroundNormal != null;
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (!this.handleClick && this.useable) {
            if (this.field_230693_o_ && this.field_230694_p_) {
                boolean flag;
                if (this.func_230987_a_(p_mouseClicked_5_) && (flag = this.func_230992_c_(p_mouseClicked_1_, p_mouseClicked_3_))) {
                    if (this.clicksound == null) {
                        this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                    } else {
                        SoundHandler.resetSound(this.clicksound);
                        SoundHandler.playSound(this.clicksound);
                    }
                    this.func_230982_a_(p_mouseClicked_1_, p_mouseClicked_3_);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.handleClick) {
            return false;
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void setUseable(boolean b) {
        this.useable = b;
    }

    public boolean isUseable() {
        return this.useable;
    }

    public void setHandleClick(boolean b) {
        this.handleClick = b;
    }

    public String getMessageString() {
        return this.func_230458_i_().getString();
    }

    public void setMessage(String msg) {
        this.func_238482_a_((ITextComponent)new StringTextComponent(msg));
    }

    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    public void func_230991_b_(int width) {
        this.field_230688_j_ = width;
    }

    public int getX() {
        return this.field_230690_l_;
    }

    public void setX(int x) {
        this.field_230690_l_ = x;
    }

    public int getY() {
        return this.field_230691_m_;
    }

    public void setY(int y) {
        this.field_230691_m_ = y;
    }

    public void setHovered(boolean b) {
        this.field_230692_n_ = b;
    }

    public void setPressAction(Button.IPressable press) {
        this.press = press;
    }

    public void setClickSound(@Nullable String key) {
        this.clicksound = key;
    }

    public void setDescription(String ... desc) {
        this.description = desc;
    }

    public String[] getDescription() {
        return this.description;
    }

    public void setLabelShadow(boolean shadow) {
        this.labelShadow = shadow;
    }

    public static boolean isAnyButtonLeftClicked() {
        return leftDown;
    }
}

