/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.block.EnchantingTableBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import snownee.jade.Jade;
import snownee.jade.JadePlugin;

public class EnchantmentPowerProvider
implements IComponentProvider {
    public static final EnchantmentPowerProvider INSTANCE = new EnchantmentPowerProvider();

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        World world = accessor.getWorld();
        BlockPos pos = accessor.getPosition();
        float power = 0.0f;
        if (accessor.getBlock() instanceof EnchantingTableBlock) {
            if (config.get(JadePlugin.TOTAL_ENCH_POWER)) {
                for (int k = -1; k <= 1; ++k) {
                    for (int l = -1; l <= 1; ++l) {
                        if (k == 0 && l == 0 || !world.func_175623_d(pos.func_177982_a(l, 0, k)) || !world.func_175623_d(pos.func_177982_a(l, 1, k))) continue;
                        power += this.getPower(world, pos.func_177982_a(l * 2, 0, k * 2));
                        power += this.getPower(world, pos.func_177982_a(l * 2, 1, k * 2));
                        if (l == 0 || k == 0) continue;
                        power += this.getPower(world, pos.func_177982_a(l * 2, 0, k));
                        power += this.getPower(world, pos.func_177982_a(l * 2, 1, k));
                        power += this.getPower(world, pos.func_177982_a(l, 0, k * 2));
                        power += this.getPower(world, pos.func_177982_a(l, 1, k * 2));
                    }
                }
            }
        } else if (config.get(JadePlugin.ENCH_POWER)) {
            power = this.getPower(world, pos);
        }
        if (power > 0.0f) {
            tooltip.add((ITextComponent)new TranslationTextComponent("jade.ench_power", new Object[]{TextFormatting.WHITE + Jade.dfCommas.format(power)}));
        }
    }

    private float getPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }
}

