/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.soundfilters.handlers;

import com.tmtravlr.soundfilters.SoundFiltersConfig;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;

public class LiquidLowPassHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static boolean waterSound = false;
    private static boolean lavaSound = false;
    private static float targetLowPassGain = 1.0f;
    private static float targetLowPassGainHF = 1.0f;
    private static float baseLowPassGain = 1.0f;
    private static float baseLowPassGainHF = 1.0f;

    public static float getLowPassGain() {
        return baseLowPassGain;
    }

    public static float getLowPassGainHF() {
        return baseLowPassGainHF;
    }

    public static void stopLiquidLowPass() {
        baseLowPassGain = 1.0f;
        baseLowPassGainHF = 1.0f;
        targetLowPassGain = 1.0f;
        targetLowPassGainHF = 1.0f;
        lavaSound = false;
        waterSound = false;
    }

    public static void updateLiquidLowPass() {
        if (((Boolean)SoundFiltersConfig.LOW_PASS_ENABLED.get()).booleanValue()) {
            if (LiquidLowPassHandler.MC.field_71441_e.func_180495_p(new BlockPos(LiquidLowPassHandler.MC.field_71439_g.func_174824_e(1.0f))).func_185904_a() == Material.field_151586_h) {
                if (!waterSound) {
                    targetLowPassGain = ((Double)SoundFiltersConfig.LOW_PASS_WATER_GAIN.get()).floatValue();
                    targetLowPassGainHF = ((Double)SoundFiltersConfig.LOW_PASS_WATER_GAIN_HF.get()).floatValue();
                    lavaSound = false;
                    waterSound = true;
                }
            } else if (waterSound) {
                targetLowPassGain = 1.0f;
                targetLowPassGainHF = 1.0f;
                waterSound = false;
            }
            if (LiquidLowPassHandler.MC.field_71441_e.func_180495_p(new BlockPos(LiquidLowPassHandler.MC.field_71439_g.func_174824_e(1.0f))).func_185904_a() == Material.field_151587_i) {
                if (!lavaSound) {
                    targetLowPassGain = ((Double)SoundFiltersConfig.LOW_PASS_LAVA_GAIN.get()).floatValue();
                    targetLowPassGainHF = ((Double)SoundFiltersConfig.LOW_PASS_LAVA_GAIN_HF.get()).floatValue();
                    lavaSound = true;
                    waterSound = false;
                }
            } else if (lavaSound) {
                targetLowPassGain = 1.0f;
                targetLowPassGainHF = 1.0f;
                lavaSound = false;
            }
            if (Math.abs(targetLowPassGain - baseLowPassGain) > 0.001f) {
                baseLowPassGain = (targetLowPassGain + baseLowPassGain) / 2.0f;
            }
            if (Math.abs(targetLowPassGainHF - baseLowPassGainHF) > 0.001f) {
                baseLowPassGainHF = (targetLowPassGainHF + baseLowPassGainHF) / 2.0f;
            }
        }
    }
}

