/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xreliquary.blocks.tile.TileEntityBase;
import xreliquary.compat.waila.provider.IWailaDataChangeIndicator;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.util.InventoryHelper;
import xreliquary.util.WorldHelper;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class ApothecaryMortarTileEntity
extends TileEntityBase
implements IWailaDataChangeIndicator {
    private static final int PESTLE_USAGE_MAX = 5;
    private int pestleUsedCounter = 0;
    private boolean dataChanged = true;
    private long finishCoolDown;
    private final ItemStackHandler items = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.isItemValid(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        private boolean isItemValid(ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_190926_b() || !this.getStackInSlot(i).func_77969_a(stack)) continue;
                return false;
            }
            return XRPotionHelper.isIngredient(stack) || XRPotionHelper.isItemEssence(stack);
        }

        protected void onContentsChanged(int slot) {
            ApothecaryMortarTileEntity.this.dataChanged = true;
            WorldHelper.notifyBlockUpdate(ApothecaryMortarTileEntity.this);
        }
    };

    public ApothecaryMortarTileEntity() {
        super((TileEntityType)ModBlocks.APOTHECARY_MORTAR_TILE_TYPE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.items.deserializeNBT(tag.func_74775_l("items"));
        this.pestleUsedCounter = tag.func_74765_d("pestleUsed");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("pestleUsed", (short)this.pestleUsedCounter);
        compound.func_218657_a("items", (INBT)this.items.serializeNBT());
        return compound;
    }

    public NonNullList<ItemStack> getItemStacks() {
        return InventoryHelper.getItemStacks((IItemHandler)this.items);
    }

    public boolean usePestle() {
        int itemCount = 0;
        ArrayList<PotionIngredient> potionIngredients = new ArrayList<PotionIngredient>();
        for (ItemStack item : this.getItemStacks()) {
            if (item.func_190926_b()) continue;
            ++itemCount;
            XRPotionHelper.getIngredient(item).ifPresent(potionIngredients::add);
        }
        if (itemCount > 1) {
            ++this.pestleUsedCounter;
            this.spawnPestleParticles();
        }
        return this.pestleUsedCounter >= 5 && this.createPotionEssence(potionIngredients);
    }

    private boolean createPotionEssence(List<PotionIngredient> potionIngredients) {
        List<EffectInstance> resultEffects = XRPotionHelper.combineIngredients(potionIngredients);
        if (resultEffects.isEmpty()) {
            this.pestleUsedCounter = 0;
            for (int clearSlot = 0; clearSlot < this.items.getSlots(); ++clearSlot) {
                if (this.items.getStackInSlot(clearSlot).func_190926_b()) continue;
                if (!this.field_145850_b.field_72995_K) {
                    ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.items.getStackInSlot(clearSlot).func_77946_l());
                    this.field_145850_b.func_217376_c((Entity)itemEntity);
                }
                this.items.setStackInSlot(clearSlot, ItemStack.field_190927_a);
            }
        } else {
            for (int clearSlot = 0; clearSlot < this.items.getSlots(); ++clearSlot) {
                this.items.setStackInSlot(clearSlot, ItemStack.field_190927_a);
            }
            this.pestleUsedCounter = 0;
            this.finishCoolDown = this.field_145850_b.func_82737_E() + 20L;
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            ItemStack resultItem = new ItemStack((IItemProvider)ModItems.POTION_ESSENCE.get());
            XRPotionHelper.addPotionEffectsToStack(resultItem, resultEffects);
            ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, resultItem);
            this.field_145850_b.func_217376_c((Entity)itemEntity);
        }
        this.func_70296_d();
        return false;
    }

    private void spawnPestleParticles() {
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.15, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.1, 0.0);
    }

    public boolean isInCooldown() {
        return this.field_145850_b.func_82737_E() < this.finishCoolDown;
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.items));
        }
        return super.getCapability(cap, side);
    }

    public void dropItems() {
        InventoryHelper.dropInventoryItems(this.field_145850_b, this.field_174879_c, (IItemHandler)this.items);
    }
}

