/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import xreliquary.entities.LyssaBobberEntity;
import xreliquary.init.ModItems;

public class LyssaHookRenderer
extends EntityRenderer<LyssaBobberEntity> {
    private static final ResourceLocation FISH_PARTICLES = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType ENTITY_CUTOUT = RenderType.func_228638_b_((ResourceLocation)FISH_PARTICLES);

    public LyssaHookRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(LyssaBobberEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        PlayerEntity playerentity = entity.getFishingPlayer();
        if (playerentity != null) {
            float f3;
            double d6;
            double d5;
            double d4;
            matrixStack.func_227860_a_();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            MatrixStack.Entry matrixStackEntry = matrixStack.func_227866_c_();
            Matrix4f matrix = matrixStackEntry.func_227870_a_();
            Matrix3f normal = matrixStackEntry.func_227872_b_();
            IVertexBuilder vertexBuilder = buffer.getBuffer(ENTITY_CUTOUT);
            LyssaHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 0.0f, 0, 0, 1);
            LyssaHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 1.0f, 0, 1, 1);
            LyssaHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 1.0f, 1, 1, 0);
            LyssaHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 0.0f, 1, 0, 0);
            matrixStack.func_227865_b_();
            int i = playerentity.func_184591_cq() == HandSide.RIGHT ? 1 : -1;
            ItemStack itemstack = playerentity.func_184614_ca();
            if (itemstack.func_77973_b() != ModItems.ROD_OF_LYSSA.get()) {
                i = -i;
            }
            float f = playerentity.func_70678_g(partialTicks);
            float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * (float)Math.PI));
            float f2 = MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_70760_ar, (float)playerentity.field_70761_aq) * ((float)Math.PI / 180);
            double d0 = MathHelper.func_76126_a((float)f2);
            double d1 = MathHelper.func_76134_b((float)f2);
            double d2 = (double)i * 0.35;
            if ((this.field_76990_c.field_78733_k == null || this.field_76990_c.field_78733_k.func_243230_g().func_243192_a()) && playerentity == Minecraft.func_71410_x().field_71439_g) {
                double d7 = this.field_76990_c.field_78733_k.field_74334_X;
                Vector3d vec3d = new Vector3d((double)i * -0.36 * (d7 /= 100.0), -0.045 * d7, 0.4);
                vec3d = vec3d.func_178789_a(-MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_70127_C, (float)playerentity.field_70125_A) * ((float)Math.PI / 180));
                vec3d = vec3d.func_178785_b(-MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_70126_B, (float)playerentity.field_70177_z) * ((float)Math.PI / 180));
                vec3d = vec3d.func_178785_b(f1 * 0.5f);
                vec3d = vec3d.func_178789_a(-f1 * 0.7f);
                d4 = MathHelper.func_219803_d((double)partialTicks, (double)playerentity.field_70169_q, (double)playerentity.func_226277_ct_()) + vec3d.field_72450_a;
                d5 = MathHelper.func_219803_d((double)partialTicks, (double)playerentity.field_70167_r, (double)playerentity.func_226278_cu_()) + vec3d.field_72448_b;
                d6 = MathHelper.func_219803_d((double)partialTicks, (double)playerentity.field_70166_s, (double)playerentity.func_226281_cx_()) + vec3d.field_72449_c;
                f3 = playerentity.func_70047_e();
            } else {
                d4 = MathHelper.func_219803_d((double)partialTicks, (double)playerentity.field_70169_q, (double)playerentity.func_226277_ct_()) - d1 * d2 - d0 * 0.8;
                d5 = playerentity.field_70167_r + (double)playerentity.func_70047_e() + (playerentity.func_226278_cu_() - playerentity.field_70167_r) * (double)partialTicks - 0.45;
                d6 = MathHelper.func_219803_d((double)partialTicks, (double)playerentity.field_70166_s, (double)playerentity.func_226281_cx_()) - d0 * d2 + d1 * 0.8;
                f3 = playerentity.func_213453_ef() ? -0.1875f : 0.0f;
            }
            double d9 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70169_q, (double)entity.func_226277_ct_());
            double d10 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70167_r, (double)entity.func_226278_cu_()) + 0.25;
            double d8 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70166_s, (double)entity.func_226281_cx_());
            float f4 = (float)(d4 - d9);
            float f5 = (float)(d5 - d10) + f3;
            float f6 = (float)(d6 - d8);
            IVertexBuilder vertexBuilder2 = buffer.getBuffer(RenderType.func_228659_m_());
            Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
            for (int k = 0; k < 16; ++k) {
                LyssaHookRenderer.addVertex(f4, f5, f6, vertexBuilder2, matrix4f1, (float)k / 16.0f);
                LyssaHookRenderer.addVertex(f4, f5, f6, vertexBuilder2, matrix4f1, (float)(k + 1) / 16.0f);
            }
            matrixStack.func_227865_b_();
            super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        }
    }

    private static void addVertex(IVertexBuilder vertexBuilder, Matrix4f matrix, Matrix3f normal, int packedLight, float x, int y, int u, int v) {
        vertexBuilder.func_227888_a_(matrix, x - 0.5f, (float)y - 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_((float)u, (float)v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static void addVertex(float x, float y, float z, IVertexBuilder vertexBuilder, Matrix4f matrix, float scale) {
        vertexBuilder.func_227888_a_(matrix, x * scale, y * (scale * scale + scale) * 0.5f + 0.25f, z * scale).func_225586_a_(0, 0, 0, 255).func_181675_d();
    }

    public ResourceLocation getEntityTexture(LyssaBobberEntity entity) {
        return FISH_PARTICLES;
    }
}

