/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import xreliquary.api.client.IPedestalItemRenderer;
import xreliquary.blocks.tile.PedestalTileEntity;

public class PedestalFishHookRenderer
implements IPedestalItemRenderer {
    private static final ResourceLocation FISH_PARTICLES = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType ENTITY_CUTOUT = RenderType.func_228638_b_((ResourceLocation)FISH_PARTICLES);

    @Override
    public void doRender(PedestalTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, int packedOverlay) {
        ((Optional)te.getItemData()).ifPresent(itemData -> this.renderHook(te, matrixStack, buffer, packedLight, itemData));
    }

    private void renderHook(PedestalTileEntity te, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, Object itemData) {
        if (!(itemData instanceof HookRenderingData)) {
            return;
        }
        HookRenderingData hookData = (HookRenderingData)itemData;
        double translateX = hookData.hookX - (double)te.func_174877_v().func_177958_n();
        double translateY = hookData.hookY - (double)te.func_174877_v().func_177956_o();
        double translateZ = hookData.hookZ - (double)te.func_174877_v().func_177952_p();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(translateX, translateY, translateZ);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(Minecraft.func_71410_x().field_71439_g.field_70759_as + 180.0f));
        MatrixStack.Entry matrixStackEntry = matrixStack.func_227866_c_();
        Matrix4f matrix = matrixStackEntry.func_227870_a_();
        Matrix3f normal = matrixStackEntry.func_227872_b_();
        IVertexBuilder vertexBuilder = buffer.getBuffer(ENTITY_CUTOUT);
        PedestalFishHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 0.0f, 0, 0, 1);
        PedestalFishHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 1.0f, 0, 1, 1);
        PedestalFishHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 1.0f, 1, 1, 0);
        PedestalFishHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 0.0f, 1, 0, 0);
        matrixStack.func_227865_b_();
        double pedestalX = (double)te.func_174877_v().func_177958_n() + 0.5;
        double pedestalY = (double)te.func_174877_v().func_177956_o() + 0.45;
        double pedestalZ = (double)te.func_174877_v().func_177952_p() + 0.5;
        double hookX = hookData.hookX;
        double hookY = hookData.hookY;
        double hookZ = hookData.hookZ;
        float xDiff = (float)(pedestalX - hookX);
        float yDiff = (float)(pedestalY - hookY);
        float zDiff = (float)(pedestalZ - hookZ);
        IVertexBuilder vertexBuilder2 = buffer.getBuffer(RenderType.func_228659_m_());
        Matrix4f lastMatrix = matrixStack.func_227866_c_().func_227870_a_();
        for (int k = 0; k < 16; ++k) {
            PedestalFishHookRenderer.addVertex(xDiff, yDiff, zDiff, vertexBuilder2, lastMatrix, (float)k / 16.0f);
            PedestalFishHookRenderer.addVertex(xDiff, yDiff, zDiff, vertexBuilder2, lastMatrix, (float)(k + 1) / 16.0f);
        }
        matrixStack.func_227865_b_();
    }

    private static void addVertex(IVertexBuilder vertexBuilder, Matrix4f matrix, Matrix3f normal, int packedLight, float x, int y, int u, int v) {
        vertexBuilder.func_227888_a_(matrix, x - 0.5f, (float)y - 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_((float)u, (float)v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static void addVertex(float x, float y, float z, IVertexBuilder vertexBuilder, Matrix4f matrix, float scale) {
        vertexBuilder.func_227888_a_(matrix, x * scale, y * (scale * scale + scale) * 0.5f + 0.25f, z * scale).func_225586_a_(0, 0, 0, 255).func_181675_d();
    }

    public static class HookRenderingData {
        final double hookX;
        final double hookY;
        final double hookZ;

        public HookRenderingData(double hookX, double hookY, double hookZ) {
            this.hookX = hookX;
            this.hookY = hookY;
            this.hookZ = hookZ;
        }
    }
}

