/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import xreliquary.crafting.PotionEffectsRecipe;
import xreliquary.crafting.conditions.PotionsEnabledCondition;

public class PotionEffectsRecipeBuilder {
    private final ShapedRecipeBuilder shapedRecipeBuilder;
    private final List<ICondition> additionalConditions = new ArrayList<ICondition>();
    private final float durationFactor;

    private PotionEffectsRecipeBuilder(IItemProvider item, int count, float durationFactor) {
        this.shapedRecipeBuilder = ShapedRecipeBuilder.func_200468_a((IItemProvider)item, (int)count);
        this.durationFactor = durationFactor;
    }

    public static PotionEffectsRecipeBuilder potionEffectsRecipe(IItemProvider item, int count, float durationFactor) {
        return new PotionEffectsRecipeBuilder(item, count, durationFactor);
    }

    public PotionEffectsRecipeBuilder addCondition(ICondition condition) {
        this.additionalConditions.add(condition);
        return this;
    }

    public PotionEffectsRecipeBuilder key(Character symbol, ITag<Item> tagIn) {
        return this.key(symbol, Ingredient.func_199805_a(tagIn));
    }

    public PotionEffectsRecipeBuilder key(Character symbol, IItemProvider itemIn) {
        return this.key(symbol, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public PotionEffectsRecipeBuilder key(Character symbol, Ingredient ingredient) {
        this.shapedRecipeBuilder.func_200471_a(symbol, ingredient);
        return this;
    }

    public PotionEffectsRecipeBuilder patternLine(String pattern) {
        this.shapedRecipeBuilder.func_200472_a(pattern);
        return this;
    }

    public PotionEffectsRecipeBuilder addCriterion(String name, ICriterionInstance criterion) {
        this.shapedRecipeBuilder.func_200465_a(name, criterion);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ConditionalRecipe.Builder builder = ConditionalRecipe.builder().addCondition((ICondition)new PotionsEnabledCondition());
        this.additionalConditions.forEach(arg_0 -> ((ConditionalRecipe.Builder)builder).addCondition(arg_0));
        this.shapedRecipeBuilder.func_200464_a(shapedResult -> builder.addRecipe(conditionalConsumer -> conditionalConsumer.accept(new Result(id, (IFinishedRecipe)shapedResult, this.durationFactor))));
        builder.build(consumer, id);
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final IFinishedRecipe shapedResult;
        private final float durationFactor;

        public Result(ResourceLocation id, IFinishedRecipe shapedResult, float durationFactor) {
            this.id = id;
            this.shapedResult = shapedResult;
            this.durationFactor = durationFactor;
        }

        public void func_218610_a(JsonObject json) {
            this.shapedResult.func_218610_a(json);
            json.addProperty("duration_factor", (Number)Float.valueOf(this.durationFactor));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return PotionEffectsRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

