/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xreliquary.Reliquary;
import xreliquary.blocks.AlkahestryAltarBlock;
import xreliquary.blocks.ApothecaryCauldronBlock;
import xreliquary.blocks.ApothecaryMortarBlock;
import xreliquary.blocks.FertileLilyPadBlock;
import xreliquary.blocks.InterdictionTorchBlock;
import xreliquary.blocks.PassivePedestalBlock;
import xreliquary.blocks.PedestalBlock;
import xreliquary.blocks.WallInterdictionTorchBlock;
import xreliquary.blocks.WraithNodeBlock;
import xreliquary.blocks.tile.AlkahestryAltarTileEntity;
import xreliquary.blocks.tile.ApothecaryCauldronTileEntity;
import xreliquary.blocks.tile.ApothecaryMortarTileEntity;
import xreliquary.blocks.tile.PassivePedestalTileEntity;
import xreliquary.blocks.tile.PedestalTileEntity;
import xreliquary.items.block.BlockItemBase;
import xreliquary.items.block.FertileLilyPadItem;
import xreliquary.util.LanguageHelper;

public class ModBlocks {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"xreliquary");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"xreliquary");
    private static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"xreliquary");
    private static final String ALKAHESTRY_ALTAR_REGISTRY_NAME = "alkahestry_altar";
    private static final String INTERDICTION_TORCH_REGISTRY_NAME = "interdiction_torch";
    private static final String APOTHECARY_CAULDRON_REGISTRY_NAME = "apothecary_cauldron";
    private static final String APOTHECARY_MORTAR_REGISTRY_NAME = "apothecary_mortar";
    private static final String FERTILE_LILY_PAD_REGISTRY_NAME = "fertile_lily_pad";
    private static final String WRAITH_NODE_REGISTRY_NAME = "wraith_node";
    public static final RegistryObject<AlkahestryAltarBlock> ALKAHESTRY_ALTAR = BLOCKS.register("alkahestry_altar", AlkahestryAltarBlock::new);
    public static final RegistryObject<ApothecaryCauldronBlock> APOTHECARY_CAULDRON = BLOCKS.register("apothecary_cauldron", ApothecaryCauldronBlock::new);
    public static final RegistryObject<ApothecaryMortarBlock> APOTHECARY_MORTAR = BLOCKS.register("apothecary_mortar", ApothecaryMortarBlock::new);
    public static final RegistryObject<FertileLilyPadBlock> FERTILE_LILY_PAD = BLOCKS.register("fertile_lily_pad", FertileLilyPadBlock::new);
    public static final RegistryObject<InterdictionTorchBlock> INTERDICTION_TORCH = BLOCKS.register("interdiction_torch", InterdictionTorchBlock::new);
    public static final RegistryObject<WallInterdictionTorchBlock> WALL_INTERDICTION_TORCH = BLOCKS.register("wall_interdiction_torch", WallInterdictionTorchBlock::new);
    public static final RegistryObject<WraithNodeBlock> WRAITH_NODE = BLOCKS.register("wraith_node", WraithNodeBlock::new);
    public static final Map<DyeColor, RegistryObject<PassivePedestalBlock>> PASSIVE_PEDESTALS;
    public static final Map<DyeColor, RegistryObject<PedestalBlock>> PEDESTALS;
    public static final RegistryObject<TileEntityType<AlkahestryAltarTileEntity>> ALKAHESTRY_ALTAR_TILE_TYPE;
    public static final RegistryObject<TileEntityType<PedestalTileEntity>> PEDESTAL_TILE_TYPE;
    public static final RegistryObject<TileEntityType<PassivePedestalTileEntity>> PASSIVE_PEDESTAL_TILE_TYPE;
    public static final RegistryObject<TileEntityType<ApothecaryCauldronTileEntity>> APOTHECARY_CAULDRON_TILE_TYPE;
    public static final RegistryObject<TileEntityType<ApothecaryMortarTileEntity>> APOTHECARY_MORTAR_TILE_TYPE;
    public static final RegistryObject<BlockItem> ALKAHESTRY_ALTAR_ITEM;
    public static final RegistryObject<BlockItem> APOTHECARY_CAULDRON_ITEM;
    public static final RegistryObject<BlockItem> APOTHECARY_MORTAR_ITEM;
    public static final RegistryObject<BlockItem> FERTILE_LILY_PAD_ITEM;
    public static final RegistryObject<BlockItem> WRAITH_NODE_ITEM;
    public static final RegistryObject<BlockItem> INTERDICTION_TORCH_ITEM;
    public static final Map<DyeColor, RegistryObject<BlockItem>> PEDESTAL_ITEMS;
    public static final Map<DyeColor, RegistryObject<BlockItem>> PASSIVE_PEDESTAL_ITEMS;

    private ModBlocks() {
    }

    public static void registerListeners(IEventBus modBus) {
        ITEMS.register(modBus);
        BLOCKS.register(modBus);
        TILE_ENTITIES.register(modBus);
    }

    private static <T extends TileEntity> TileEntityType<T> getTileEntityType(Supplier<T> tileFactory, Block ... validBlocks) {
        return TileEntityType.Builder.func_223042_a(tileFactory, (Block[])validBlocks).func_206865_a(null);
    }

    static {
        ImmutableMap.Builder passiveBuilder = ImmutableMap.builder();
        ImmutableMap.Builder activeBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            passiveBuilder.put((Object)color, (Object)BLOCKS.register("pedestals/passive/" + color.func_176762_d() + "_passive_pedestal", PassivePedestalBlock::new));
            activeBuilder.put((Object)color, (Object)BLOCKS.register("pedestals/" + color.func_176762_d() + "_pedestal", PedestalBlock::new));
        }
        PASSIVE_PEDESTALS = passiveBuilder.build();
        PEDESTALS = activeBuilder.build();
        ALKAHESTRY_ALTAR_TILE_TYPE = TILE_ENTITIES.register(ALKAHESTRY_ALTAR_REGISTRY_NAME, () -> ModBlocks.getTileEntityType(AlkahestryAltarTileEntity::new, (Block)ALKAHESTRY_ALTAR.get()));
        PEDESTAL_TILE_TYPE = TILE_ENTITIES.register("pedestal", () -> ModBlocks.getTileEntityType(PedestalTileEntity::new, (Block[])PEDESTALS.values().stream().map(RegistryObject::get).toArray(PedestalBlock[]::new)));
        PASSIVE_PEDESTAL_TILE_TYPE = TILE_ENTITIES.register("passive_pedestal", () -> ModBlocks.getTileEntityType(PassivePedestalTileEntity::new, (Block[])PASSIVE_PEDESTALS.values().stream().map(RegistryObject::get).toArray(PassivePedestalBlock[]::new)));
        APOTHECARY_CAULDRON_TILE_TYPE = TILE_ENTITIES.register(APOTHECARY_CAULDRON_REGISTRY_NAME, () -> ModBlocks.getTileEntityType(ApothecaryCauldronTileEntity::new, (Block)APOTHECARY_CAULDRON.get()));
        APOTHECARY_MORTAR_TILE_TYPE = TILE_ENTITIES.register(APOTHECARY_MORTAR_REGISTRY_NAME, () -> ModBlocks.getTileEntityType(ApothecaryMortarTileEntity::new, (Block)APOTHECARY_MORTAR.get()));
        ALKAHESTRY_ALTAR_ITEM = ITEMS.register(ALKAHESTRY_ALTAR_REGISTRY_NAME, () -> new BlockItemBase((Block)ALKAHESTRY_ALTAR.get()));
        APOTHECARY_CAULDRON_ITEM = ITEMS.register(APOTHECARY_CAULDRON_REGISTRY_NAME, () -> new BlockItemBase((Block)APOTHECARY_CAULDRON.get()));
        APOTHECARY_MORTAR_ITEM = ITEMS.register(APOTHECARY_MORTAR_REGISTRY_NAME, () -> new BlockItemBase((Block)APOTHECARY_MORTAR.get()));
        FERTILE_LILY_PAD_ITEM = ITEMS.register(FERTILE_LILY_PAD_REGISTRY_NAME, FertileLilyPadItem::new);
        WRAITH_NODE_ITEM = ITEMS.register(WRAITH_NODE_REGISTRY_NAME, () -> new BlockItemBase((Block)WRAITH_NODE.get()));
        INTERDICTION_TORCH_ITEM = ITEMS.register(INTERDICTION_TORCH_REGISTRY_NAME, () -> new WallOrFloorItem((Block)INTERDICTION_TORCH.get(), (Block)WALL_INTERDICTION_TORCH.get(), new Item.Properties().func_200916_a(Reliquary.ITEM_GROUP)){

            public ITextComponent func_200295_i(ItemStack stack) {
                return new StringTextComponent(LanguageHelper.getLocalization(this.func_77667_c(stack), new Object[0]));
            }
        });
        passiveBuilder = ImmutableMap.builder();
        activeBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            passiveBuilder.put((Object)color, (Object)ITEMS.register("pedestals/passive/" + color.func_176762_d() + "_passive_pedestal", () -> new BlockItemBase((Block)PASSIVE_PEDESTALS.get(color).get(), new Item.Properties()){

                public ITextComponent func_200295_i(ItemStack stack) {
                    return new TranslationTextComponent("block.xreliquary.passive_pedestal");
                }
            }));
            activeBuilder.put((Object)color, (Object)ITEMS.register("pedestals/" + color.func_176762_d() + "_pedestal", () -> new BlockItemBase((Block)PEDESTALS.get(color).get(), new Item.Properties()){

                public ITextComponent func_200295_i(ItemStack stack) {
                    return new TranslationTextComponent("block.xreliquary.pedestal");
                }
            }));
        }
        PASSIVE_PEDESTAL_ITEMS = passiveBuilder.build();
        PEDESTAL_ITEMS = activeBuilder.build();
    }
}

