/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xreliquary.reference.Settings;

@Mod.EventBusSubscriber(modid="xreliquary")
public class ModLoot {
    private static final List<String> CHEST_TABLES = ImmutableList.of((Object)"abandoned_mineshaft", (Object)"desert_pyramid", (Object)"end_city_treasure", (Object)"igloo_chest", (Object)"jungle_temple", (Object)"nether_bridge", (Object)"simple_dungeon", (Object)"stronghold_corridor", (Object)"stronghold_crossing", (Object)"stronghold_library", (Object)"village_blacksmith");
    private static final List<String> ENTITY_TABLES = ImmutableList.of((Object)"bat", (Object)"blaze", (Object)"cave_spider", (Object)"creeper", (Object)"enderman", (Object)"ghast", (Object)"guardian", (Object)"husk", (Object)"magma_cube", (Object)"skeleton", (Object)"slime", (Object)"snow_golem", (Object[])new String[]{"spider", "stray", "squid", "witch", "wither_skeleton", "zombie", "zombified_piglin", "zombie_villager"});

    private ModLoot() {
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        String chestsPrefix = "minecraft:chests/";
        String entitiesPrefix = "minecraft:entities/";
        String name = evt.getName().toString();
        if (((Boolean)Settings.COMMON.chestLootEnabled.get()).booleanValue() && name.startsWith(chestsPrefix) && CHEST_TABLES.contains(name.substring(chestsPrefix.length())) || ((Boolean)Settings.COMMON.mobDropsEnabled.get()).booleanValue() && name.startsWith(entitiesPrefix) && ENTITY_TABLES.contains(name.substring(entitiesPrefix.length()))) {
            String file = name.substring("minecraft:".length());
            evt.getTable().addPool(ModLoot.getInjectPool(file));
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().func_216045_a(ModLoot.getInjectEntry(entryName)).bonusRolls(0.0f, 1.0f).name("xreliquary_inject_pool").func_216044_b();
    }

    private static LootEntry.Builder<?> getInjectEntry(String name) {
        return TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("xreliquary", "inject/" + name)).func_216086_a(1);
    }
}

