/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.items.IceMagusRodItem;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class GlacialStaffItem
extends IceMagusRodItem {
    private static final String SNOWBALLS_TAG = "snowballs";
    private static final String BLOCK_LOCATIONS_TAG = "blockLocations";

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInt(SNOWBALLS_TAG, staff))), tooltip);
        if (this.isEnabled(staff)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.BLUE + Items.field_151126_ay.func_200295_i(new ItemStack((IItemProvider)Items.field_151126_ay)).toString())), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity e) {
        if (e instanceof LivingEntity && NBTHelper.getInt(SNOWBALLS_TAG, stack) >= this.getSnowballCost()) {
            LivingEntity livingBase = (LivingEntity)e;
            EffectInstance slow = new EffectInstance(Effects.field_76421_d, 30, 0);
            EffectInstance slownessEffect = livingBase.func_70660_b(Effects.field_76421_d);
            if (slownessEffect != null) {
                slow = new EffectInstance(Effects.field_76421_d, Math.min(slownessEffect.func_76459_b() + 30, 300), Math.min(slownessEffect.func_76458_c() + 1, 4));
            }
            ((LivingEntity)e).func_195064_c(slow);
            e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)slow.func_76458_c());
            NBTHelper.putInt(SNOWBALLS_TAG, stack, NBTHelper.getInt(SNOWBALLS_TAG, stack) - this.getSnowballCost());
        }
        return super.onLeftClickEntity(stack, player, e);
    }

    @Override
    public void func_77663_a(ItemStack staff, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(staff, world, entity, itemSlot, isSelected);
        if (world.func_82737_E() % 2L != 0L) {
            return;
        }
        PlayerEntity player = null;
        if (entity instanceof PlayerEntity) {
            player = (PlayerEntity)entity;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(staff)) {
            this.freezeBlocks(staff, world, player);
        }
        this.meltBlocks(staff, world, player);
    }

    private void freezeBlocks(ItemStack staff, World world, PlayerEntity player) {
        BlockPos playerPos = player.func_233580_cy_();
        BlockPos.func_218278_a((BlockPos)playerPos.func_177982_a(-2, -1, -2), (BlockPos)playerPos.func_177982_a(2, -1, 2)).forEach(pos -> {
            if (Math.abs(playerPos.func_177958_n() - pos.func_177958_n()) == 2 && Math.abs(playerPos.func_177952_p() - pos.func_177952_p()) == 2) {
                return;
            }
            this.doFreezeCheck(staff, (BlockPos)pos, world);
        });
    }

    private void meltBlocks(ItemStack staff, World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            BlockPos playerPos = player.func_233580_cy_();
            for (BlockPos pos : this.getBlockLocations(staff)) {
                int xOff = Math.abs(playerPos.func_177958_n() - pos.func_177958_n());
                int yOff = Math.abs(playerPos.func_177956_o() - pos.func_177956_o());
                int zOff = Math.abs(playerPos.func_177952_p() - pos.func_177952_p());
                if (xOff < 3 && yOff < 3 && zOff < 3 && (xOff != 2 || zOff != 2)) continue;
                this.doThawCheck(staff, pos, world);
            }
        }
    }

    private Set<BlockPos> getBlockLocations(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        HashSet<BlockPos> locations = new HashSet<BlockPos>();
        tagCompound.func_150295_c(BLOCK_LOCATIONS_TAG, 4).forEach(nbt -> locations.add(BlockPos.func_218283_e((long)((LongNBT)nbt).func_150291_c())));
        return locations;
    }

    private void doFreezeCheck(ItemStack stack, BlockPos pos, World world) {
        block3: {
            BlockState blockState;
            block2: {
                blockState = world.func_180495_p(pos);
                if (blockState.func_177230_c() != Blocks.field_150355_j || (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) != 0 || !world.func_175623_d(pos.func_177984_a())) break block2;
                this.addFrozenBlockToList(stack, pos);
                world.func_175656_a(pos, Blocks.field_150403_cj.func_176223_P());
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)ICE_PARTICLE, (double)((float)pos.func_177958_n() + xVel), (double)((float)pos.func_177956_o() + yVel), (double)((float)pos.func_177952_p() + zVel), 0.75, 0.75, 1.0);
                }
                break block3;
            }
            if (blockState.func_177230_c() != Blocks.field_150353_l || (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) != 0) break block3;
            this.addFrozenBlockToList(stack, pos);
            world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
            for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                float xVel = world.field_73012_v.nextFloat();
                float yVel = world.field_73012_v.nextFloat() + 0.5f;
                float zVel = world.field_73012_v.nextFloat();
                world.func_195594_a((IParticleData)(world.field_73012_v.nextInt(3) == 0 ? ParticleTypes.field_197594_E : ParticleTypes.field_197601_L), (double)((float)pos.func_177958_n() + xVel), (double)((float)pos.func_177956_o() + yVel), (double)((float)pos.func_177952_p() + zVel), 0.0, 0.2, 0.0);
            }
        }
    }

    private void doThawCheck(ItemStack stack, BlockPos pos, World world) {
        block4: {
            BlockState blockState;
            block3: {
                blockState = world.func_180495_p(pos);
                if (blockState != Blocks.field_150403_cj.func_176223_P()) break block3;
                if (!this.removeFrozenBlockFromList(stack, pos)) break block4;
                world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)(world.field_73012_v.nextInt(3) == 0 ? ParticleTypes.field_197594_E : ParticleTypes.field_197601_L), (double)((float)pos.func_177958_n() + xVel), (double)((float)pos.func_177956_o() + yVel), (double)((float)pos.func_177952_p() + zVel), 0.0, 0.2, 0.0);
                }
                break block4;
            }
            if (blockState == Blocks.field_150343_Z.func_176223_P() && this.removeFrozenBlockFromList(stack, pos)) {
                world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
                for (int particleNum = world.field_73012_v.nextInt(3); particleNum < 2; ++particleNum) {
                    float xVel = world.field_73012_v.nextFloat();
                    float yVel = world.field_73012_v.nextFloat() + 0.5f;
                    float zVel = world.field_73012_v.nextFloat();
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)((float)pos.func_177958_n() + xVel), (double)((float)pos.func_177956_o() + yVel), (double)((float)pos.func_177952_p() + zVel), 0.0, (double)0.2f, 0.0);
                }
            }
        }
    }

    private void addFrozenBlockToList(ItemStack stack, BlockPos pos) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        ListNBT tagList = tagCompound.func_150295_c(BLOCK_LOCATIONS_TAG, 4);
        tagList.add((Object)LongNBT.func_229698_a_((long)pos.func_218275_a()));
        tagCompound.func_218657_a(BLOCK_LOCATIONS_TAG, (INBT)tagList);
        stack.func_77982_d(tagCompound);
    }

    private boolean removeFrozenBlockFromList(ItemStack stack, BlockPos pos) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        ListNBT tagList = tagCompound.func_150295_c(BLOCK_LOCATIONS_TAG, 4);
        Iterator it = tagList.iterator();
        boolean removedBlock = false;
        while (it.hasNext()) {
            LongNBT nbtPos = (LongNBT)it.next();
            if (nbtPos.func_150291_c() != pos.func_218275_a()) continue;
            it.remove();
            removedBlock = true;
        }
        if (removedBlock) {
            tagCompound.func_218657_a(BLOCK_LOCATIONS_TAG, (INBT)tagList);
            stack.func_77982_d(tagCompound);
        }
        return removedBlock;
    }
}

