/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.Reliquary;
import xreliquary.util.LanguageHelper;

public class ItemBase
extends Item {
    private final Supplier<Boolean> isDisabled;

    public ItemBase() {
        this(new Item.Properties(), () -> false);
    }

    public ItemBase(Supplier<Boolean> isDisabled) {
        this(new Item.Properties(), isDisabled);
    }

    public ItemBase(Item.Properties properties) {
        this(properties, () -> false);
    }

    public ItemBase(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties.func_200916_a(Reliquary.ITEM_GROUP));
        this.isDisabled = isDisabled;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (Boolean.TRUE.equals(this.isDisabled.get())) {
            return;
        }
        super.func_150895_a(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (LanguageHelper.localizationExists(this.func_77658_a() + ".tooltip")) {
            LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip", tooltip);
        }
        if (this.hasMoreInformation(stack)) {
            if (Screen.func_231173_s_()) {
                ArrayList detailTooltip = Lists.newArrayList();
                this.addMoreInformation(stack, world, detailTooltip);
                if (!detailTooltip.isEmpty()) {
                    tooltip.add((ITextComponent)new StringTextComponent(""));
                    tooltip.addAll(detailTooltip);
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.xreliquary.shift_for_more_info").func_240699_a_(TextFormatting.WHITE).func_240699_a_(TextFormatting.ITALIC));
            }
        }
    }

    protected boolean hasMoreInformation(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent(LanguageHelper.getLocalization(this.func_77667_c(stack), new Object[0]));
    }
}

