/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;

public class KrakenShellItem
extends ItemBase {
    public KrakenShellItem() {
        super(new Item.Properties().func_200917_a(1));
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(PlayerEntity player, LivingAttackEvent event) {
                return event.getSource() == DamageSource.field_76369_e && player.func_71024_bL().func_75116_a() > 0 && InventoryHelper.playerHasItem(player, (Item)ModItems.KRAKEN_SHELL.get());
            }

            @Override
            public boolean apply(PlayerEntity player, LivingAttackEvent event) {
                float hungerDamage = event.getAmount() * ((float)((Integer)Settings.COMMON.items.krakenShell.hungerCostPercent.get()).intValue() / 100.0f);
                player.func_71020_j(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        PlayerEntity player;
        if (world.func_82737_E() % 3L != 0L) {
            return;
        }
        if (entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_70090_H()) {
            player.func_195064_c(new EffectInstance(Effects.field_76422_e, 5, 0, true, false));
            player.func_195064_c(new EffectInstance(Effects.field_76424_c, 5, 0, true, false));
            player.func_195064_c(new EffectInstance(Effects.field_76439_r, 220, 0, true, false));
        }
    }
}

