/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.TieredItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.items.ToggleableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class MidasTouchstoneItem
extends ToggleableItem {
    private static final Map<Class<? extends Item>, IRepairableItem> REPAIRABLE_ITEMS = new ImmutableMap.Builder().put(TieredItem.class, item -> {
        IItemTier tier = ((TieredItem)item).func_200891_e();
        return tier.equals(ItemTier.GOLD) || tier.equals(ItemTier.NETHERITE);
    }).put(ArmorItem.class, item -> {
        IArmorMaterial material = ((ArmorItem)item).func_200880_d();
        return material.equals(ArmorMaterial.GOLD) || material.equals(ArmorMaterial.NETHERITE);
    }).build();
    private static final String GLOWSTONE_TAG = "glowstone";

    public MidasTouchstoneItem() {
        super(new Item.Properties().func_200917_a(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack touchstone, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInt(GLOWSTONE_TAG, touchstone))), tooltip);
        if (this.isEnabled(touchstone)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + Items.field_151114_aO.func_200295_i(new ItemStack((IItemProvider)Items.field_151114_aO)).getString())), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void func_77663_a(ItemStack stack, World world, Entity e, int i, boolean f) {
        if (world.field_72995_K || world.func_82737_E() % 10L != 0L || !(e instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)e;
        if (this.isEnabled(stack)) {
            int glowstoneCharge = NBTHelper.getInt(GLOWSTONE_TAG, stack);
            this.consumeAndCharge(player, this.getGlowstoneLimit() - glowstoneCharge, this.getGlowStoneWorth(), Items.field_151114_aO, 16, (int chargeToAdd) -> NBTHelper.putInt(GLOWSTONE_TAG, stack, glowstoneCharge + chargeToAdd));
        }
        this.doRepairAndDamageTouchstone(stack, player);
    }

    private void doRepairAndDamageTouchstone(ItemStack touchstone, PlayerEntity player) {
        List goldItems = (List)Settings.COMMON.items.midasTouchstone.goldItems.get();
        InventoryHelper.getItemHandlerFrom(player, null).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                Item item = stack.func_77973_b();
                if (stack.func_77952_i() <= 0 || !stack.func_77973_b().func_77645_m()) continue;
                this.tryRepairingItem(touchstone, player, goldItems, stack, item);
            }
        });
    }

    private void tryRepairingItem(ItemStack touchstone, PlayerEntity player, List<String> goldItems, ItemStack stack, Item item) {
        Optional<IRepairableItem> repairableItem = this.getRepairableItem(item.getClass());
        if (repairableItem.isPresent()) {
            if (!repairableItem.get().materialMatches(item)) {
                return;
            }
            this.repairItem(stack, touchstone, player);
        } else if (goldItems.contains(RegistryHelper.getItemRegistryName(item))) {
            this.repairItem(stack, touchstone, player);
        }
    }

    private void repairItem(ItemStack stack, ItemStack touchstone, PlayerEntity player) {
        if (this.reduceTouchStoneCharge(touchstone, player)) {
            int damage = stack.func_77952_i();
            stack.func_196085_b(damage - Math.min(damage, 10));
        }
    }

    private boolean reduceTouchStoneCharge(ItemStack stack, PlayerEntity player) {
        if (NBTHelper.getInt(GLOWSTONE_TAG, stack) - this.getGlowStoneCost() >= 0 || player.func_184812_l_()) {
            if (!player.func_184812_l_()) {
                NBTHelper.putInt(GLOWSTONE_TAG, stack, NBTHelper.getInt(GLOWSTONE_TAG, stack) - this.getGlowStoneCost());
            }
            return true;
        }
        return false;
    }

    private int getGlowStoneCost() {
        return (Integer)Settings.COMMON.items.midasTouchstone.glowstoneCost.get();
    }

    private int getGlowStoneWorth() {
        return (Integer)Settings.COMMON.items.midasTouchstone.glowstoneWorth.get();
    }

    private int getGlowstoneLimit() {
        return (Integer)Settings.COMMON.items.midasTouchstone.glowstoneLimit.get();
    }

    private Optional<IRepairableItem> getRepairableItem(Class<? extends Item> item) {
        for (Map.Entry<Class<? extends Item>, IRepairableItem> repairableItem : REPAIRABLE_ITEMS.entrySet()) {
            if (!repairableItem.getKey().isAssignableFrom(item)) continue;
            return Optional.of(repairableItem.getValue());
        }
        return Optional.empty();
    }

    private static interface IRepairableItem {
        public boolean materialMatches(Item var1);
    }
}

