/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xreliquary.blocks.tile.PedestalTileEntity;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.items.MobCharmBeltItem;
import xreliquary.items.MobCharmDefinition;
import xreliquary.items.MobCharmRegistry;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketMobCharmDamage;
import xreliquary.pedestal.PedestalRegistry;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.MobHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.WorldHelper;

public class MobCharmItem
extends ItemBase {
    private CharmInventoryHandler charmInventoryHandler = new CharmInventoryHandler();

    public MobCharmItem() {
        super(new Item.Properties().func_200917_a(1).func_200918_c(((Integer)Settings.COMMON.items.mobCharm.durability.get()).intValue()).setNoRepair());
        MinecraftForge.EVENT_BUS.addListener(this::onEntityTargetedEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingDeath);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(MobCharmItem.getEntityEggRegistryName(stack));
        if (entityType == null) {
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(LanguageHelper.getLocalization(this.func_77658_a() + ".tooltip", entityType.func_212546_e().getString())));
    }

    @Override
    public ITextComponent func_200295_i(ItemStack stack) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(MobCharmItem.getEntityEggRegistryName(stack));
        if (entityType == null) {
            return super.func_200295_i(stack);
        }
        return new StringTextComponent(LanguageHelper.getLocalization(this.func_77658_a(), entityType.func_212546_e().getString()));
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        for (String entityRegistryName : MobCharmRegistry.getRegisteredNames()) {
            items.add((Object)this.getStackFor(entityRegistryName));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y != EnchantmentType.BREAKABLE && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        if (!(event.getTarget() instanceof PlayerEntity) || event.getTarget() instanceof FakePlayer || !(event.getEntity() instanceof MobEntity)) {
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        MobCharmRegistry.getCharmDefinitionFor((Entity)entity).ifPresent(charmDefinition -> {
            if (this.isMobCharmPresent((PlayerEntity)event.getTarget(), (MobCharmDefinition)charmDefinition)) {
                MobHelper.resetTarget(entity);
            }
        });
    }

    private void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof MobEntity)) {
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        PlayerEntity player = null;
        if (entity.func_70638_az() instanceof PlayerEntity && !(entity.func_70638_az() instanceof FakePlayer)) {
            player = (PlayerEntity)entity.func_70638_az();
        } else if (entity.func_70643_av() instanceof PlayerEntity && !(entity.func_70643_av() instanceof FakePlayer)) {
            player = (PlayerEntity)entity.func_70643_av();
        }
        if (player == null) {
            return;
        }
        PlayerEntity finalPlayer = player;
        MobCharmRegistry.getCharmDefinitionFor((Entity)entity).filter(MobCharmDefinition::resetTargetInLivingUpdateEvent).ifPresent(charmDefinition -> {
            if (this.isMobCharmPresent(finalPlayer, (MobCharmDefinition)charmDefinition)) {
                MobHelper.resetTarget(entity, true);
            }
        });
    }

    private void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource() == null || event.getSource().func_76346_g() == null || !(event.getSource().func_76346_g() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
        MobCharmRegistry.getCharmDefinitionFor(event.getEntity()).ifPresent(charmDefinition -> {
            if (!this.charmInventoryHandler.damagePlayersMobCharm(player, charmDefinition.getRegistryName())) {
                this.damageMobCharmInPedestal(player, charmDefinition.getRegistryName());
            }
        });
    }

    private void damageMobCharmInPedestal(PlayerEntity player, String entityRegistryName) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.field_70170_p.func_234923_W_().getRegistryName(), player.func_233580_cy_(), (Integer)Settings.COMMON.items.mobCharm.pedestalRange.get());
        World world = player.func_130014_f_();
        for (BlockPos pos : pedestalPositions) {
            WorldHelper.getTile((IBlockReader)world, pos, PedestalTileEntity.class).ifPresent(pedestal -> this.damageMobCharmInPedestal(player, entityRegistryName, (PedestalTileEntity)pedestal));
        }
    }

    private void damageMobCharmInPedestal(PlayerEntity player, String entityRegistryName, PedestalTileEntity pedestal) {
        if (pedestal.isEnabled()) {
            ItemStack pedestalItem = pedestal.getItem();
            if (MobCharmItem.isCharmFor(pedestalItem, entityRegistryName)) {
                if (pedestalItem.func_77952_i() + (Integer)Settings.COMMON.items.mobCharm.damagePerKill.get() > pedestalItem.func_77958_k()) {
                    pedestal.destroyItem();
                } else {
                    pedestalItem.func_196085_b(pedestalItem.func_77952_i() + (Integer)Settings.COMMON.items.mobCharm.damagePerKill.get());
                }
            } else if (pedestalItem.func_77973_b() == ModItems.MOB_CHARM_BELT.get()) {
                ((MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get()).damageCharm(player, pedestalItem, entityRegistryName);
            }
        }
    }

    private boolean isMobCharmPresent(PlayerEntity player, MobCharmDefinition charmDefinition) {
        return this.charmInventoryHandler.playerHasMobCharm(player, charmDefinition) || this.pedestalWithCharmInRange(player, charmDefinition);
    }

    private boolean isCharmOrBeltFor(ItemStack slotStack, String registryName) {
        return MobCharmItem.isCharmFor(slotStack, registryName) || slotStack.func_77973_b() == ModItems.MOB_CHARM_BELT.get() && ((MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get()).hasCharm(slotStack, registryName);
    }

    static boolean isCharmFor(ItemStack slotStack, String registryName) {
        return slotStack.func_77973_b() == ModItems.MOB_CHARM.get() && MobCharmItem.getEntityRegistryName(slotStack).equals(registryName);
    }

    private boolean pedestalWithCharmInRange(PlayerEntity player, MobCharmDefinition charmDefinition) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.field_70170_p.func_234923_W_().getRegistryName(), player.func_233580_cy_(), (Integer)Settings.COMMON.items.mobCharm.pedestalRange.get());
        World world = player.func_130014_f_();
        for (BlockPos pos : pedestalPositions) {
            if (!WorldHelper.getTile((IBlockReader)world, pos, PedestalTileEntity.class).map(pedestal -> this.hasCharm(charmDefinition.getRegistryName(), (PedestalTileEntity)pedestal)).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean hasCharm(String entityRegistryName, PedestalTileEntity pedestal) {
        if (pedestal.isEnabled()) {
            ItemStack pedestalItem = pedestal.getItem();
            return this.isCharmOrBeltFor(pedestalItem, entityRegistryName);
        }
        return false;
    }

    static String getEntityRegistryName(ItemStack charm) {
        return NBTHelper.getString("entity", charm);
    }

    public static void setEntityRegistryName(ItemStack charm, String regName) {
        NBTHelper.putString("entity", charm, regName);
    }

    public ItemStack getStackFor(String entityRegistryName) {
        ItemStack ret = new ItemStack((IItemProvider)this);
        MobCharmItem.setEntityRegistryName(ret, entityRegistryName);
        return ret;
    }

    public static ResourceLocation getEntityEggRegistryName(ItemStack charm) {
        return new ResourceLocation(MobCharmItem.getEntityRegistryName(charm));
    }

    public void setCharmInventoryHandler(CharmInventoryHandler charmInventoryHandler) {
        this.charmInventoryHandler = charmInventoryHandler;
    }

    public static class CharmInventoryHandler {
        public boolean playerHasMobCharm(PlayerEntity player, MobCharmDefinition charmDefinition) {
            String registryName = charmDefinition.getRegistryName();
            for (ItemStack slotStack : player.field_71071_by.field_70462_a) {
                if (slotStack.func_190926_b() || !((MobCharmItem)ModItems.MOB_CHARM.get()).isCharmOrBeltFor(slotStack, registryName)) continue;
                return true;
            }
            return false;
        }

        public boolean damagePlayersMobCharm(PlayerEntity player, String entityRegistryName) {
            if (player.func_184812_l_()) {
                return true;
            }
            return this.damageCharmInPlayersInventory(player, entityRegistryName);
        }

        private Boolean damageCharmInPlayersInventory(PlayerEntity player, String entityRegistryName) {
            for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
                if (stack.func_190926_b()) continue;
                if (MobCharmItem.isCharmFor(stack, entityRegistryName)) {
                    if (stack.func_77952_i() + (Integer)Settings.COMMON.items.mobCharm.damagePerKill.get() > stack.func_77958_k()) {
                        player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
                        PacketHandler.sendToClient((ServerPlayerEntity)player, new PacketMobCharmDamage(ItemStack.field_190927_a, slot));
                    } else {
                        stack.func_196085_b(stack.func_77952_i() + (Integer)Settings.COMMON.items.mobCharm.damagePerKill.get());
                        PacketHandler.sendToClient((ServerPlayerEntity)player, new PacketMobCharmDamage(stack, slot));
                    }
                    return true;
                }
                if (!this.damageMobCharmInBelt((ServerPlayerEntity)player, entityRegistryName, stack)) continue;
                return true;
            }
            return false;
        }

        protected boolean damageMobCharmInBelt(ServerPlayerEntity player, String entityRegistryName, ItemStack belt) {
            ItemStack charmStack;
            if (belt.func_77973_b() == ModItems.MOB_CHARM_BELT.get() && !(charmStack = ((MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get()).damageCharm((PlayerEntity)player, belt, entityRegistryName)).func_190926_b()) {
                PacketHandler.sendToClient(player, new PacketMobCharmDamage(charmStack, -1));
                return true;
            }
            return false;
        }
    }
}

