/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util;

import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import xreliquary.items.util.FilteredBigItemStack;

public class FilteredItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundNBT> {
    private boolean dynamicSlotNumber = false;
    private final List<RemovableStack> filteredBigItemStacks;
    private static final String NOT_IN_RANGE_ERROR = "%s %d not in valid range - (0, %d)";

    FilteredItemStackHandler(List<RemovableStack> filteredBigItemStacks) {
        this.filteredBigItemStacks = filteredBigItemStacks;
    }

    public void setTotalAmount(int bigStackSlot, int amount) {
        if (this.dynamicSlotNumber && amount == 0 && this.filteredBigItemStacks.get(bigStackSlot).canRemove) {
            this.filteredBigItemStacks.remove(bigStackSlot);
        } else {
            this.filteredBigItemStacks.get(bigStackSlot).getStack().setAmount(amount);
        }
    }

    public int getTotalAmount(int bigStackSlot) {
        this.validateBigStackSlot(bigStackSlot);
        return this.filteredBigItemStacks.get(bigStackSlot).getStack().getAmount();
    }

    private void validateBigStackSlot(int bigStackSlot) {
        if (bigStackSlot < 0 || bigStackSlot >= this.filteredBigItemStacks.size()) {
            throw new IllegalArgumentException(String.format(NOT_IN_RANGE_ERROR, "Big Stack Slot", bigStackSlot, this.filteredBigItemStacks.size() - 1));
        }
    }

    public void markDirty() {
        Iterator<RemovableStack> it = this.filteredBigItemStacks.iterator();
        while (it.hasNext()) {
            RemovableStack removableStack = it.next();
            FilteredBigItemStack stack = removableStack.getStack();
            stack.markDirty();
            if (!stack.isEmpty() || !removableStack.canRemove) continue;
            it.remove();
        }
    }

    public FilteredBigItemStack getBigStack(int bigStackSlot) {
        this.validateBigStackSlot(bigStackSlot);
        return this.filteredBigItemStacks.get(bigStackSlot).getStack();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        int bigStackSlot = this.getBigStackSlot(slot);
        if (this.filteredBigItemStacks.size() > bigStackSlot ? !this.isValidForBigStackSlot(stack, bigStackSlot) : this.alreadyExistsInAnotherSlot(stack, bigStackSlot)) {
            return;
        }
        if (this.isValidForDynamicStack(stack)) {
            this.addDynamicBigStack(stack, bigStackSlot);
        }
        this.updateBigStack(slot, stack, bigStackSlot);
    }

    protected boolean isValidForBigStackSlot(ItemStack stack, int bigStackSlot) {
        return this.filteredBigItemStacks.get(bigStackSlot).getStack().isValid(stack);
    }

    private void updateBigStack(int slot, ItemStack stack, int bigStackSlot) {
        RemovableStack removableStack = this.filteredBigItemStacks.get(bigStackSlot);
        FilteredBigItemStack bigStack = removableStack.getStack();
        if (this.isInputSlot(slot)) {
            bigStack.setInputStack(stack);
        } else {
            bigStack.setOutputStack(stack);
        }
        bigStack.markDirty();
        if (bigStack.isEmpty() && removableStack.canRemove()) {
            this.filteredBigItemStacks.remove(bigStackSlot);
        }
    }

    private void addDynamicBigStack(ItemStack stack, int bigStackSlot) {
        if (this.dynamicSlotNumber && !stack.func_190926_b() && bigStackSlot == this.filteredBigItemStacks.size()) {
            ItemStack filter = stack.func_77946_l();
            filter.func_190920_e(1);
            this.filteredBigItemStacks.add(new RemovableStack(new FilteredBigItemStack(filter, this.getDynamicStackLimit()), true));
        }
    }

    protected int getDynamicStackLimit() {
        return Integer.MAX_VALUE;
    }

    int getBigStackSlot(int slot) {
        return slot / 2;
    }

    private boolean alreadyExistsInAnotherSlot(ItemStack stack, int bigStackSlot) {
        for (int i = 0; i < this.filteredBigItemStacks.size(); ++i) {
            if (i == bigStackSlot || !this.isValidForBigStackSlot(stack, i)) continue;
            return true;
        }
        return false;
    }

    public int getSlots() {
        return this.filteredBigItemStacks.size() * 2 + (this.dynamicSlotNumber ? 1 : 0);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int getBigStackSlots() {
        return this.filteredBigItemStacks.size();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        return this.isValidForBigStackSlot(stack, this.getBigStackSlot(slot));
    }

    private boolean isInputSlot(int slot) {
        return slot % 2 == 0;
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        int bigStackSlot = this.getBigStackSlot(slot);
        if (bigStackSlot < this.filteredBigItemStacks.size()) {
            FilteredBigItemStack bigStack = this.filteredBigItemStacks.get(0).getStack();
            return this.isInputSlot(slot) ? bigStack.getInputStack() : bigStack.getOutputStack();
        }
        return ItemStack.field_190927_a;
    }

    void setBigStack(int bigStackSlot, RemovableStack removableStack) {
        if (bigStackSlot < 0 || bigStackSlot > this.filteredBigItemStacks.size()) {
            throw new IllegalArgumentException(String.format(NOT_IN_RANGE_ERROR, "Big Stack Slot", bigStackSlot, this.filteredBigItemStacks.size()));
        }
        if (bigStackSlot == this.filteredBigItemStacks.size()) {
            this.filteredBigItemStacks.add(removableStack);
            return;
        }
        this.filteredBigItemStacks.set(bigStackSlot, removableStack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        int bigStackSlot = this.getBigStackSlot(slot);
        if (bigStackSlot == this.filteredBigItemStacks.size()) {
            if (this.alreadyExistsInAnotherSlot(stack, bigStackSlot) || !this.isValidForDynamicStack(stack)) return stack;
            if (simulate) return ItemStack.field_190927_a;
            this.addDynamicBigStack(stack, bigStackSlot);
        }
        if (this.isValidForBigStackSlot(stack, bigStackSlot)) return this.filteredBigItemStacks.get(bigStackSlot).getStack().insertItem(stack, simulate, this.isInputSlot(slot));
        return stack;
    }

    protected boolean isValidForDynamicStack(ItemStack stack) {
        return true;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack currentStack;
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        if (slot >= this.getSlots() - 1) {
            return ItemStack.field_190927_a;
        }
        int bigStackSlot = this.getBigStackSlot(slot);
        FilteredBigItemStack bigStack = this.filteredBigItemStacks.get(bigStackSlot).getStack();
        ItemStack itemStack = currentStack = this.isInputSlot(slot) ? bigStack.getInputStack() : bigStack.getOutputStack();
        if (currentStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int numberRemoved = Math.min(currentStack.func_190916_E(), amount);
        ItemStack ret = ItemHandlerHelper.copyStackWithSize((ItemStack)currentStack, (int)numberRemoved);
        if (!simulate) {
            ItemStack updatedStack = numberRemoved == currentStack.func_190916_E() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)currentStack, (int)(currentStack.func_190916_E() - numberRemoved));
            this.updateBigStack(slot, updatedStack, bigStackSlot);
        }
        return ret;
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (RemovableStack removableStack : this.filteredBigItemStacks) {
            FilteredBigItemStack bigStack = removableStack.getStack();
            nbtTagList.add((Object)bigStack.serializeNBT());
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            if (i < this.filteredBigItemStacks.size()) {
                this.filteredBigItemStacks.get(i).getStack().deserializeNBT(itemTags);
                continue;
            }
            FilteredBigItemStack bigStack = new FilteredBigItemStack(this.getDynamicStackLimit());
            bigStack.deserializeNBT(itemTags);
            this.filteredBigItemStacks.add(new RemovableStack(bigStack, true));
        }
    }

    void setDynamicSlotNumber() {
        this.dynamicSlotNumber = true;
    }

    private void validateSlotIndex(int slot) {
        int slots = this.getSlots();
        if (slot < 0 || slot >= slots) {
            throw new IllegalArgumentException(String.format(NOT_IN_RANGE_ERROR, "Slot", slot, this.filteredBigItemStacks.size() - 1));
        }
    }

    public static class RemovableStack {
        private final FilteredBigItemStack stack;
        private final boolean canRemove;

        public RemovableStack(FilteredBigItemStack stack, boolean canRemove) {
            this.stack = stack;
            this.canRemove = canRemove;
        }

        public FilteredBigItemStack getStack() {
            return this.stack;
        }

        boolean canRemove() {
            return this.canRemove;
        }
    }
}

