/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import xreliquary.util.NBTHelper;

public class PacketCountSync {
    private final Hand hand;
    private final short slot;
    private final ItemStack stack;
    private final int count;

    public PacketCountSync(Hand hand, short slot, ItemStack stack, int count) {
        this.hand = hand;
        this.slot = slot;
        this.stack = stack;
        this.count = count;
    }

    static void encode(PacketCountSync msg, PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(msg.hand == Hand.MAIN_HAND);
        packetBuffer.writeShort((int)msg.slot);
        packetBuffer.func_150786_a(msg.stack.func_77955_b(new CompoundNBT()));
        packetBuffer.writeInt(msg.count);
    }

    static PacketCountSync decode(PacketBuffer packetBuffer) {
        return new PacketCountSync(packetBuffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND, packetBuffer.readShort(), ItemStack.func_199557_a((CompoundNBT)packetBuffer.func_150793_b()), packetBuffer.readInt());
    }

    static void onMessage(PacketCountSync msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketCountSync.handleMessage(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(PacketCountSync message) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack container = player.func_184586_b(message.hand);
        NBTHelper.updateContainedStack(container, message.slot, message.stack, message.count, message.stack.func_190926_b());
    }
}

