/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.collectors;

import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ShapelessWalker {
    public static final BlockPos[] NEIGHBOR_POSITIONS = new BlockPos[26];

    public List<BlockPos> getBlocks(World level, BlockPos pos) {
        HashSet<BlockPos> known = new HashSet<BlockPos>();
        this.walk(level, pos, known);
        return new ArrayList<BlockPos>(known);
    }

    private void walk(World level, BlockPos pos, HashSet<BlockPos> known) {
        HashSet<BlockPos> traversed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> openSet = new ArrayDeque<BlockPos>();
        openSet.add(pos);
        traversed.add(pos);
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.pop();
            Block block = level.func_180495_p(ptr).func_177230_c();
            if (block != Blocks.field_196617_K && block != ModBlocks.RENDER_BLOCK.get() || !known.add(ptr)) continue;
            System.out.println(block);
            if (known.size() >= 60) {
                return;
            }
            for (BlockPos side : NEIGHBOR_POSITIONS) {
                BlockPos offset = ptr.func_177971_a((Vector3i)side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }

    static {
        ShapelessWalker.NEIGHBOR_POSITIONS[0] = new BlockPos(1, 0, 0);
        ShapelessWalker.NEIGHBOR_POSITIONS[1] = new BlockPos(-1, 0, 0);
        ShapelessWalker.NEIGHBOR_POSITIONS[2] = new BlockPos(0, 0, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[3] = new BlockPos(0, 0, -1);
        ShapelessWalker.NEIGHBOR_POSITIONS[4] = new BlockPos(0, 1, 0);
        ShapelessWalker.NEIGHBOR_POSITIONS[5] = new BlockPos(0, -1, 0);
        ShapelessWalker.NEIGHBOR_POSITIONS[6] = new BlockPos(1, 0, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[7] = new BlockPos(1, 0, -1);
        ShapelessWalker.NEIGHBOR_POSITIONS[8] = new BlockPos(-1, 0, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[9] = new BlockPos(-1, 0, -1);
        ShapelessWalker.NEIGHBOR_POSITIONS[10] = new BlockPos(1, 1, 0);
        ShapelessWalker.NEIGHBOR_POSITIONS[11] = new BlockPos(-1, 1, 0);
        ShapelessWalker.NEIGHBOR_POSITIONS[12] = new BlockPos(0, 1, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[13] = new BlockPos(0, 1, -1);
        ShapelessWalker.NEIGHBOR_POSITIONS[14] = new BlockPos(1, -1, 0);
        ShapelessWalker.NEIGHBOR_POSITIONS[15] = new BlockPos(-1, -1, 0);
        ShapelessWalker.NEIGHBOR_POSITIONS[16] = new BlockPos(0, -1, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[17] = new BlockPos(0, -1, -1);
        ShapelessWalker.NEIGHBOR_POSITIONS[18] = new BlockPos(1, 1, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[19] = new BlockPos(1, 1, -1);
        ShapelessWalker.NEIGHBOR_POSITIONS[20] = new BlockPos(-1, 1, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[21] = new BlockPos(-1, 1, -1);
        ShapelessWalker.NEIGHBOR_POSITIONS[22] = new BlockPos(1, -1, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[23] = new BlockPos(1, -1, -1);
        ShapelessWalker.NEIGHBOR_POSITIONS[24] = new BlockPos(-1, -1, 1);
        ShapelessWalker.NEIGHBOR_POSITIONS[25] = new BlockPos(-1, -1, -1);
    }
}

