/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.gadget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class MiningProperties {
    private static final String KEY_BEAM_RANGE = "beamRange";
    private static final String KEY_MAX_BEAM_RANGE = "maxBeamRange";
    private static final String KEY_WHITELIST = "isWhitelist";
    private static final String KEY_RANGE = "range";
    private static final String KEY_SPEED = "speed";
    private static final String BREAK_TYPE = "breakType";
    private static final String CAN_MINE = "canMine";
    private static final String PRECISION_MODE = "precisionMode";
    private static final String VOLUME = "volume";
    private static final String FREEZE_PARTICLE_DELAY = "freeze_particle_delay";
    public static final String KEY_FILTERS = "filters";
    public static final String COLOR_RED = "colorRed";
    public static final String COLOR_GREEN = "colorGreen";
    public static final String COLOR_BLUE = "colorBlue";
    public static final String COLOR_RED_INNER = "colorRedInner";
    public static final String COLOR_GREEN_INNER = "colorGreenInner";
    public static final String COLOR_BLUE_INNER = "colorBlueInner";
    public static final int MIN_RANGE = 5;

    private MiningProperties() {
    }

    public static short getColor(ItemStack gadget, String color) {
        CompoundNBT compound = gadget.func_196082_o();
        if (color.equals(COLOR_RED) || color.contains("Inner")) {
            return !compound.func_74764_b(color) ? MiningProperties.setColor(gadget, (short)255, color) : compound.func_74765_d(color);
        }
        return !compound.func_74764_b(color) ? MiningProperties.setColor(gadget, (short)0, color) : compound.func_74765_d(color);
    }

    public static short setColor(ItemStack gadget, short colorValue, String color) {
        gadget.func_196082_o().func_74777_a(color, colorValue);
        return colorValue;
    }

    public static BreakTypes setBreakType(ItemStack gadget, BreakTypes breakType) {
        gadget.func_196082_o().func_74774_a(BREAK_TYPE, (byte)breakType.ordinal());
        return breakType;
    }

    public static void nextBreakType(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        if (compound.func_74764_b(BREAK_TYPE)) {
            int type = MiningProperties.getBreakType(gadget).ordinal() == BreakTypes.values().length - 1 ? 0 : MiningProperties.getBreakType(gadget).ordinal() + 1;
            MiningProperties.setBreakType(gadget, BreakTypes.values()[type]);
        } else {
            MiningProperties.setBreakType(gadget, BreakTypes.FADE);
        }
    }

    public static BreakTypes getBreakType(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(BREAK_TYPE) ? MiningProperties.setBreakType(gadget, BreakTypes.SHRINK) : BreakTypes.values()[compound.func_74771_c(BREAK_TYPE)];
    }

    public static int setSpeed(ItemStack gadget, int speed) {
        gadget.func_196082_o().func_74768_a(KEY_SPEED, speed);
        return speed;
    }

    public static int getSpeed(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(KEY_SPEED) ? MiningProperties.setSpeed(gadget, 1) : compound.func_74762_e(KEY_SPEED);
    }

    public static int setRange(ItemStack gadget, int range) {
        gadget.func_196082_o().func_74768_a(KEY_RANGE, range);
        return range;
    }

    public static int getRange(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(KEY_RANGE) ? MiningProperties.setRange(gadget, 1) : compound.func_74762_e(KEY_RANGE);
    }

    public static int setBeamRange(ItemStack gadget, int range) {
        gadget.func_196082_o().func_74768_a(KEY_BEAM_RANGE, range);
        return range;
    }

    public static int setBeamMaxRange(ItemStack gadget, int range) {
        gadget.func_196082_o().func_74768_a(KEY_MAX_BEAM_RANGE, range);
        return range;
    }

    public static int getBeamRange(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(KEY_BEAM_RANGE) ? MiningProperties.setBeamRange(gadget, 5) : compound.func_74762_e(KEY_BEAM_RANGE);
    }

    public static int getBeamMaxRange(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(KEY_MAX_BEAM_RANGE) ? MiningProperties.setBeamMaxRange(gadget, 5) : compound.func_74762_e(KEY_MAX_BEAM_RANGE);
    }

    public static boolean setWhitelist(ItemStack gadget, boolean isWhitelist) {
        gadget.func_196082_o().func_74757_a(KEY_WHITELIST, isWhitelist);
        return isWhitelist;
    }

    public static boolean getWhiteList(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(KEY_WHITELIST) ? MiningProperties.setWhitelist(gadget, true) : compound.func_74767_n(KEY_WHITELIST);
    }

    public static boolean setCanMine(ItemStack gadget, boolean canMine) {
        gadget.func_196082_o().func_74757_a(CAN_MINE, canMine);
        return canMine;
    }

    public static boolean getCanMine(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(CAN_MINE) ? MiningProperties.setCanMine(gadget, true) : compound.func_74767_n(CAN_MINE);
    }

    public static boolean setPrecisionMode(ItemStack gadget, boolean precisionMode) {
        gadget.func_196082_o().func_74757_a(PRECISION_MODE, precisionMode);
        return precisionMode;
    }

    public static boolean getPrecisionMode(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(PRECISION_MODE) ? MiningProperties.setPrecisionMode(gadget, false) : compound.func_74767_n(PRECISION_MODE);
    }

    public static float setVolume(ItemStack gadget, float volume) {
        gadget.func_196082_o().func_74776_a(VOLUME, Math.max(0.0f, Math.min(1.0f, volume)));
        return volume;
    }

    public static float getVolume(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(VOLUME) ? MiningProperties.setVolume(gadget, 1.0f) : compound.func_74760_g(VOLUME);
    }

    public static int setFreezeDelay(ItemStack gadget, int volume) {
        gadget.func_196082_o().func_74768_a(FREEZE_PARTICLE_DELAY, Math.max(0, Math.min(10, volume)));
        return volume;
    }

    public static int getFreezeDelay(ItemStack gadget) {
        CompoundNBT compound = gadget.func_196082_o();
        return !compound.func_74764_b(FREEZE_PARTICLE_DELAY) ? MiningProperties.setFreezeDelay(gadget, 0) : compound.func_74762_e(FREEZE_PARTICLE_DELAY);
    }

    public static List<ItemStack> getFiltersAsList(ItemStack gadget) {
        return MiningProperties.deserializeItemStackList(gadget.func_190925_c(KEY_FILTERS));
    }

    public static List<ItemStack> deserializeItemStackList(CompoundNBT nbt) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            stacks.add(ItemStack.func_199557_a((CompoundNBT)itemTags));
        }
        return stacks;
    }

    public static CompoundNBT serializeItemStackList(List<ItemStack> stacks) {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            stacks.get(i).func_77955_b(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        return nbt;
    }

    public static enum BreakTypes {
        SHRINK,
        FADE;

    }
}

