/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketChangeColor {
    private final short red;
    private final short green;
    private final short blue;
    private final short red_inner;
    private final short green_inner;
    private final short blue_inner;

    public PacketChangeColor(int red, int green, int blue, int red_inner, int green_inner, int blue_inner) {
        this.red = (short)red;
        this.green = (short)green;
        this.blue = (short)blue;
        this.red_inner = (short)red_inner;
        this.green_inner = (short)green_inner;
        this.blue_inner = (short)blue_inner;
    }

    public static void encode(PacketChangeColor msg, PacketBuffer buffer) {
        buffer.writeShort((int)msg.red);
        buffer.writeShort((int)msg.green);
        buffer.writeShort((int)msg.blue);
        buffer.writeShort((int)msg.red_inner);
        buffer.writeShort((int)msg.green_inner);
        buffer.writeShort((int)msg.blue_inner);
    }

    public static PacketChangeColor decode(PacketBuffer buffer) {
        return new PacketChangeColor(buffer.readShort(), buffer.readShort(), buffer.readShort(), buffer.readShort(), buffer.readShort(), buffer.readShort());
    }

    public static class Handler {
        public static void handle(PacketChangeColor msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = MiningGadget.getGadget((PlayerEntity)player);
                MiningProperties.setColor(stack, msg.red, "colorRed");
                MiningProperties.setColor(stack, msg.green, "colorGreen");
                MiningProperties.setColor(stack, msg.blue, "colorBlue");
                MiningProperties.setColor(stack, msg.red_inner, "colorRedInner");
                MiningProperties.setColor(stack, msg.green_inner, "colorGreenInner");
                MiningProperties.setColor(stack, msg.blue_inner, "colorBlueInner");
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

