/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Mob;
import com.earth2me.essentials.User;
import com.earth2me.essentials.utils.LocationUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import java.util.Locale;
import net.ess3.api.IEssentials;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class EssentialsBlockListener
implements Listener {
    private final transient IEssentials ess;

    public EssentialsBlockListener(IEssentials ess) {
        this.ess = ess;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        User user;
        BlockState blockState;
        final ItemStack is = LocationUtil.convertBlockToItem(event.getBlockPlaced());
        if (is == null) {
            return;
        }
        if (is.getType() == MaterialUtil.SPAWNER && event.getItemInHand() != null && event.getPlayer() != null && event.getItemInHand().getType() == MaterialUtil.SPAWNER && (blockState = event.getBlockPlaced().getState()) instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            EntityType type = this.ess.getSpawnerItemProvider().getEntityType(event.getItemInHand());
            if (type != null && Mob.fromBukkitType(type) != null && this.ess.getUser(event.getPlayer()).isAuthorized("essentials.spawnerconvert." + Mob.fromBukkitType(type).name().toLowerCase(Locale.ENGLISH))) {
                spawner.setSpawnedType(type);
                spawner.update();
            }
        }
        if ((user = this.ess.getUser(event.getPlayer())).hasUnlimited(is) && user.getBase().getGameMode() == GameMode.SURVIVAL) {
            class UnlimitedItemSpawnTask
            implements Runnable {
                UnlimitedItemSpawnTask() {
                }

                @Override
                public void run() {
                    user.getBase().getInventory().addItem(new ItemStack[]{is});
                    user.getBase().updateInventory();
                }
            }
            this.ess.scheduleSyncDelayedTask(new UnlimitedItemSpawnTask());
        }
    }
}

