/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.IConf;
import com.earth2me.essentials.register.payment.Methods;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;

public class EssentialsPluginListener
implements Listener,
IConf {
    private final transient IEssentials ess;

    public EssentialsPluginListener(IEssentials ess) {
        this.ess = ess;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginEnable(PluginEnableEvent event) {
        if (event.getPlugin().getName().equals("EssentialsChat")) {
            this.ess.getSettings().setEssentialsChatActive(true);
        }
        this.ess.getPermissionsHandler().setUseSuperperms(this.ess.getSettings().useBukkitPermissions());
        this.ess.getPermissionsHandler().checkPermissions();
        this.ess.getAlternativeCommandsHandler().addPlugin(event.getPlugin());
        if (!Methods.hasMethod() && Methods.setMethod(this.ess.getServer().getPluginManager())) {
            this.ess.getLogger().log(Level.INFO, "Payment method found (" + Methods.getMethod().getLongName() + " version: " + Methods.getMethod().getVersion() + ")");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().getName().equals("EssentialsChat")) {
            this.ess.getSettings().setEssentialsChatActive(false);
        }
        this.ess.getPermissionsHandler().checkPermissions();
        this.ess.getAlternativeCommandsHandler().removePlugin(event.getPlugin());
        if (Methods.hasMethod() && Methods.checkDisabled(event.getPlugin())) {
            Methods.reset();
            this.ess.getLogger().log(Level.INFO, "Payment method was disabled. No longer accepting payments.");
        }
    }

    @Override
    public void reloadConfig() {
    }
}

