/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import net.ess3.nms.refl.ReflUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;

public class EssentialsServerListener
implements Listener {
    private static final List<String> ignoredSLPECallers = Arrays.asList(".LegacyPingHandler.channelRead(", "de.dytanic.cloudnet.bridge.BukkitBootstrap", "de.dytanic.cloudnet.ext.bridge.bukkit.BukkitCloudNetBridgePlugin");
    private final transient IEssentials ess;
    private final boolean isPaperSample;
    private boolean unsupportedLogged = false;
    private boolean npeWarned = false;
    private Method setSampleText;
    private Method getSampleText;

    public EssentialsServerListener(IEssentials ess) {
        this.ess = ess;
        if (ReflUtil.getClassCached("com.destroystokyo.paper.event.server.PaperServerListPingEvent") == null) {
            this.setSampleText = ReflUtil.getMethodCached(ServerListPingEvent.class, "setSampleText", List.class);
            this.getSampleText = ReflUtil.getMethodCached(ServerListPingEvent.class, "getSampleText");
            if (this.setSampleText != null && this.getSampleText != null) {
                ess.getLogger().info("ServerListPingEvent: Paper 1.12.2 setSampleText API");
                this.isPaperSample = true;
                return;
            }
        }
        ess.getLogger().info("ServerListPingEvent: Spigot iterator API");
        this.isPaperSample = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.LOWEST)
    public void onServerListPing(ServerListPingEvent event) throws Exception {
        if (this.isPaperSample) {
            try {
                List playerNames = (List)this.getSampleText.invoke((Object)event, null);
                playerNames.removeIf(player -> this.ess.getUser((String)player).isVanished());
                this.setSampleText.invoke((Object)event, playerNames);
                return;
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                if (this.unsupportedLogged || !this.shouldWarnSLPECaller(e)) return;
                this.ess.getLogger().log(Level.WARNING, "Unable to hide players from server list ping using Paper 1.12 method!", e);
                this.unsupportedLogged = true;
                return;
            }
            catch (NullPointerException e) {
                if (this.npeWarned || !this.shouldWarnSLPECaller(e)) return;
                this.npeWarned = true;
                Exception ex = new Exception("A plugin has fired a ServerListPingEvent without implementing Paper's methods. Point the author to https://git.io/v7Xzl.");
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
        }
        try {
            Iterator iterator = event.iterator();
            while (iterator.hasNext()) {
                Player player2 = (Player)iterator.next();
                if (!this.ess.getUser(player2).isVanished()) continue;
                iterator.remove();
            }
            return;
        }
        catch (UnsupportedOperationException e) {
            if (this.unsupportedLogged || !this.shouldWarnSLPECaller(e)) return;
            this.ess.getLogger().log(Level.WARNING, "Could not hide vanished players while handling " + event.getClass().getName(), e);
            this.unsupportedLogged = true;
        }
    }

    private boolean shouldWarnSLPECaller(Throwable throwable) {
        int maxStackDepth = 20;
        int depth = 0;
        for (StackTraceElement element : throwable.getStackTrace()) {
            if (++depth > 20) break;
            for (String ignoredString : ignoredSLPECallers) {
                if (!element.toString().contains(ignoredString)) continue;
                return false;
            }
        }
        return true;
    }
}

