/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.Kit;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.utils.NumberUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class Kits
implements IConf {
    private final EssentialsConf config;
    private ConfigurationSection kits;

    public Kits(IEssentials essentials) {
        this.config = new EssentialsConf(new File(essentials.getDataFolder(), "kits.yml"));
        this.config.setTemplateName("/kits.yml");
        this.reloadConfig();
    }

    @Override
    public void reloadConfig() {
        this.config.load();
        this.kits = this._getKits();
    }

    private ConfigurationSection _getKits() {
        if (this.config.isConfigurationSection("kits")) {
            ConfigurationSection section = this.config.getConfigurationSection("kits");
            MemoryConfiguration newSection = new MemoryConfiguration();
            for (String kitItem : section.getKeys(false)) {
                if (!section.isConfigurationSection(kitItem)) continue;
                newSection.set(kitItem.toLowerCase(Locale.ENGLISH), (Object)section.getConfigurationSection(kitItem));
            }
            return newSection;
        }
        return null;
    }

    public EssentialsConf getConfig() {
        return this.config;
    }

    public ConfigurationSection getKits() {
        return this.kits;
    }

    public Map<String, Object> getKit(String name) {
        ConfigurationSection kits;
        name = name.replace('.', '_').replace('/', '_');
        if (this.getKits() != null && (kits = this.getKits()).isConfigurationSection(name.toLowerCase())) {
            return kits.getConfigurationSection(name.toLowerCase()).getValues(true);
        }
        return null;
    }

    public String matchKit(String name) {
        ConfigurationSection section;
        if (this.config.isConfigurationSection("kits") && (section = this.config.getConfigurationSection("kits")) != null) {
            for (String kitName : section.getKeys(false)) {
                if (!kitName.equalsIgnoreCase(name)) continue;
                return kitName;
            }
        }
        return null;
    }

    public void addKit(String name, List<String> lines, long delay) {
        this.config.set("kits." + name + ".delay", delay);
        this.config.set("kits." + name + ".items", lines);
        this.kits = this._getKits();
        this.config.save();
    }

    public void removeKit(String name) {
        this.config.set("kits." + name, null);
        this.kits = this._getKits();
        this.config.save();
    }

    public String listKits(net.ess3.api.IEssentials ess, User user) throws Exception {
        try {
            ConfigurationSection kits = this.config.getConfigurationSection("kits");
            StringBuilder list = new StringBuilder();
            for (String kitItem : kits.getKeys(false)) {
                Kit kit;
                double nextUse;
                if (user == null) {
                    list.append(" ").append(I18n.capitalCase(kitItem));
                    continue;
                }
                if (!user.isAuthorized("essentials.kits." + kitItem.toLowerCase(Locale.ENGLISH))) continue;
                String cost = "";
                String name = I18n.capitalCase(kitItem);
                BigDecimal costPrice = new Trade("kit-" + kitItem.toLowerCase(Locale.ENGLISH), ess).getCommandCost(user);
                if (costPrice.signum() > 0) {
                    cost = I18n.tl("kitCost", NumberUtil.displayCurrency(costPrice, ess));
                }
                if ((nextUse = (double)(kit = new Kit(kitItem, ess)).getNextUse(user)) == -1.0 && ess.getSettings().isSkippingUsedOneTimeKitsFromKitList()) continue;
                if (nextUse != 0.0) {
                    name = I18n.tl("kitDelay", name);
                }
                list.append(" ").append(name).append(cost);
            }
            return list.toString().trim();
        }
        catch (Exception ex) {
            throw new Exception(I18n.tl("kitError", new Object[0]), ex);
        }
    }
}

