/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.lang.reflect.Method;
import net.ess3.nms.refl.ReflUtil;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;

public final class MobCompat {
    public static final Class RAIDER = ReflUtil.getClassCached("org.bukkit.entity.Raider");
    public static final EntityType LLAMA = EnumUtil.getEntityType("LLAMA");
    public static final EntityType PARROT = EnumUtil.getEntityType("PARROT");
    public static final EntityType TROPICAL_FISH = EnumUtil.getEntityType("TROPICAL_FISH");
    public static final EntityType PANDA = EnumUtil.getEntityType("PANDA");
    public static final EntityType TRADER_LLAMA = EnumUtil.getEntityType("TRADER_LLAMA");
    public static final EntityType SHULKER = EnumUtil.getEntityType("SHULKER");
    public static final EntityType STRAY = EnumUtil.getEntityType("STRAY");
    public static final EntityType FOX = EnumUtil.getEntityType("FOX");
    public static final EntityType PHANTOM = EnumUtil.getEntityType("PHANTOM");
    public static final EntityType CAT = EnumUtil.getEntityType("CAT", "OCELOT");
    public static final EntityType ZOMBIFIED_PIGLIN = EnumUtil.getEntityType("ZOMBIFIED_PIGLIN", "PIG_ZOMBIE");

    private MobCompat() {
    }

    public static void setCatType(Entity entity, CatType type) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            ((Ocelot)entity).setCatType(Ocelot.Type.valueOf((String)type.ocelotTypeName));
        } else {
            Class<?> cat = ReflUtil.getClassCached("org.bukkit.entity.Cat");
            Class<?> catType = ReflUtil.getClassCached("org.bukkit.entity.Cat$Type");
            Method setCatType = ReflUtil.getMethodCached(cat, "setCatType", catType);
            try {
                setCatType.invoke((Object)entity, EnumUtil.valueOf(catType, type.catTypeName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setVillagerProfession(Entity entity, VillagerProfession profession) {
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        villager.setProfession(profession.asEnum());
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            Class<?> villagerCareer = ReflUtil.getClassCached("org.bukkit.entity.Villager$Career");
            Method setCareer = ReflUtil.getMethodCached(Villager.class, "setCareer", villagerCareer);
            try {
                setCareer.invoke((Object)entity, EnumUtil.valueOf(villagerCareer, profession.oldCareer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setVillagerType(Entity entity, String type) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            return;
        }
        if (entity instanceof Villager) {
            ((Villager)entity).setVillagerType(Villager.Type.valueOf((String)type));
        }
    }

    public static void setLlamaColor(Entity entity, String color) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_11_R01)) {
            return;
        }
        if (entity instanceof Llama) {
            ((Llama)entity).setColor(Llama.Color.valueOf((String)color));
        }
    }

    public static void setParrotVariant(Entity entity, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_12_0_R01)) {
            return;
        }
        if (entity instanceof Parrot) {
            ((Parrot)entity).setVariant(Parrot.Variant.valueOf((String)variant));
        }
    }

    public static void setTropicalFishPattern(Entity entity, String pattern) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_12_0_R01)) {
            return;
        }
        if (entity instanceof TropicalFish) {
            ((TropicalFish)entity).setPattern(TropicalFish.Pattern.valueOf((String)pattern));
        }
    }

    public static void setMooshroomVariant(Entity entity, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            return;
        }
        if (entity instanceof MushroomCow) {
            ((MushroomCow)entity).setVariant(MushroomCow.Variant.valueOf((String)variant));
        }
    }

    public static void setPandaGene(Entity entity, String gene, boolean mainGene) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            return;
        }
        if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            Panda.Gene pandaGene = Panda.Gene.valueOf((String)gene);
            if (mainGene) {
                panda.setMainGene(pandaGene);
            } else {
                panda.setHiddenGene(pandaGene);
            }
        }
    }

    public static void setFoxType(Entity entity, String type) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            return;
        }
        if (entity instanceof Fox) {
            ((Fox)entity).setFoxType(Fox.Type.valueOf((String)type));
        }
    }

    public static enum VillagerProfession {
        NONE("FARMER", "FARMER", "NONE"),
        ARMORER("BLACKSMITH", "ARMORER"),
        BUTCHER("FARMER", "BUTCHER"),
        CARTOGRAPHER("LIBRARIAN", "CARTOGRAPHER"),
        CLERIC("PRIEST", "CLERIC"),
        FARMER("FARMER", "FARMER"),
        FISHERMAN("FARMER", "FISHERMAN"),
        FLETCHER("FARMER", "FLETCHER"),
        LEATHERWORKER("BUTCHER", "LEATHERWORKER"),
        LIBRARIAN("LIBRARIAN", "LIBRARIAN"),
        MASON(null, null, "MASON"),
        NITWIT("NITWIT", "NITWIT"),
        SHEPHERD("FARMER", "SHEPHERD"),
        TOOLSMITH("BLACKSMITH", "TOOL_SMITH", "TOOLSMITH"),
        WEAPONSMITH("BLACKSMITH", "WEAPON_SMITH", "WEAPONSMITH");

        private final String oldProfession;
        private final String oldCareer;
        private final String newProfession;

        private VillagerProfession(String oldProfession, String career) {
            this.oldProfession = oldProfession;
            this.oldCareer = career;
            this.newProfession = career;
        }

        private VillagerProfession(String oldProfession, String oldCareer, String newProfession) {
            this.oldProfession = oldProfession;
            this.oldCareer = oldCareer;
            this.newProfession = newProfession;
        }

        private Villager.Profession asEnum() {
            return EnumUtil.valueOf(Villager.Profession.class, this.newProfession, this.oldProfession);
        }
    }

    public static enum CatType {
        SIAMESE("SIAMESE", "SIAMESE_CAT"),
        WHITE("WHITE", "SIAMESE_CAT"),
        RED("RED", "RED_CAT"),
        TABBY("TABBY", "RED_CAT"),
        TUXEDO("BLACK", "BLACK_CAT"),
        BRITISH_SHORTHAIR("BRITISH_SHORTHAIR", "SIAMESE_CAT"),
        CALICO("CALICO", "RED_CAT"),
        PERSIAN("PERSIAN", "RED_CAT"),
        RAGDOLL("RAGDOLL", "SIAMESE_CAT"),
        JELLIE("JELLIE", "SIAMESE_CAT"),
        BLACK("ALL_BLACK", "BLACK_CAT");

        private final String catTypeName;
        private final String ocelotTypeName;

        private CatType(String catTypeName, String ocelotTypeName) {
            this.catTypeName = catTypeName;
            this.ocelotTypeName = ocelotTypeName;
        }
    }
}

