/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.VersionUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class Worth
implements IConf {
    private final EssentialsConf config;

    public Worth(File dataFolder) {
        this.config = new EssentialsConf(new File(dataFolder, "worth.yml"));
        this.config.setTemplateName("/worth.yml");
        this.config.load();
    }

    public BigDecimal getPrice(IEssentials ess, ItemStack itemStack) {
        ConfigurationSection itemNameMatch;
        String itemname = itemStack.getType().toString().toLowerCase(Locale.ENGLISH).replace("_", "");
        BigDecimal result = this.config.getBigDecimal("worth." + itemname + "." + itemStack.getDurability(), BigDecimal.ONE.negate());
        if (result.signum() < 0 && (itemNameMatch = this.config.getConfigurationSection("worth." + itemname)) != null && itemNameMatch.getKeys(false).size() == 1) {
            result = this.config.getBigDecimal("worth." + itemname + ".0", BigDecimal.ONE.negate());
        }
        if (result.signum() < 0) {
            result = this.config.getBigDecimal("worth." + itemname + ".*", BigDecimal.ONE.negate());
        }
        if (result.signum() < 0) {
            result = this.config.getBigDecimal("worth." + itemname, BigDecimal.ONE.negate());
        }
        if (result.signum() < 0) {
            return null;
        }
        return result;
    }

    public int getAmount(IEssentials ess, User user, ItemStack is, String[] args, boolean isBulkSell) throws Exception {
        if (is == null || is.getType() == Material.AIR) {
            throw new Exception(I18n.tl("itemSellAir", new Object[0]));
        }
        int amount = 0;
        if (args.length > 1) {
            try {
                amount = Integer.parseInt(args[1].replaceAll("[^0-9]", ""));
            }
            catch (NumberFormatException ex) {
                throw new NotEnoughArgumentsException(ex);
            }
            if (args[1].startsWith("-")) {
                amount = -amount;
            }
        }
        boolean stack = args.length > 1 && args[1].endsWith("s");
        boolean requireStack = ess.getSettings().isTradeInStacks(is.getType());
        if (requireStack && !stack) {
            throw new Exception(I18n.tl("itemMustBeStacked", new Object[0]));
        }
        int max = 0;
        for (ItemStack s : user.getBase().getInventory().getContents()) {
            if (s == null || !s.isSimilar(is)) continue;
            max += s.getAmount();
        }
        if (stack) {
            amount *= is.getType().getMaxStackSize();
        }
        if (amount < 1) {
            amount += max;
        }
        if (requireStack) {
            amount -= amount % is.getType().getMaxStackSize();
        }
        if (amount > max || amount < 1) {
            if (!isBulkSell) {
                user.sendMessage(I18n.tl("itemNotEnough2", new Object[0]));
                user.sendMessage(I18n.tl("itemNotEnough3", new Object[0]));
                throw new Exception(I18n.tl("itemNotEnough1", new Object[0]));
            }
            return amount;
        }
        return amount;
    }

    public void setPrice(IEssentials ess, ItemStack itemStack, double price) {
        String path = "worth." + itemStack.getType().toString().toLowerCase(Locale.ENGLISH).replace("_", "");
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_13_0_R01) && itemStack.getType().getData() == null) {
            path = path + "." + itemStack.getDurability();
        }
        this.config.setProperty(path, price);
        this.config.save();
    }

    @Override
    public void reloadConfig() {
        this.config.load();
    }
}

