/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.api;

import com.earth2me.essentials.EssentialsUserConf;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.api.NoLoanPermittedException;
import com.earth2me.essentials.api.UserDoesNotExistException;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.base.Charsets;
import java.io.File;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.MessageFormat;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import net.ess3.api.MaxMoneyException;
import net.ess3.api.events.UserBalanceUpdateEvent;
import org.bukkit.entity.Player;

public class Economy {
    public static final MathContext MATH_CONTEXT = MathContext.DECIMAL128;
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private static IEssentials ess;
    private static final String WARN_CALL_BEFORE_LOAD = "Essentials API is called before Essentials is loaded.";
    private static final String WARN_EXISTING_NPC_CREATE = "Account creation was requested for NPC account {0}, but account already exists (UUID: {1}). Not creating an account.";
    private static final String WARN_PLAYER_UUID_NO_NAME = "Found player {0} by UUID {1} but not by their actual name. They may have changed their username.";
    private static final String WARN_NPC_RECREATE_1 = "Account creation was requested for NPC user {0}, but an account file with UUID {1} already exists.";
    private static final String WARN_NPC_RECREATE_2 = "Essentials will create a new account as requested by the other plugin, but this is almost certainly a bug and should be reported.";

    protected Economy() {
    }

    public static void setEss(IEssentials aEss) {
        ess = aEss;
    }

    private static void createNPCFile(String name) {
        File folder = new File(ess.getDataFolder(), "userdata");
        name = StringUtil.safeString(name);
        if (!folder.exists() && !folder.mkdirs()) {
            throw new RuntimeException("Error while creating userdata directory!");
        }
        UUID npcUUID = UUID.nameUUIDFromBytes(("NPC:" + name).getBytes(Charsets.UTF_8));
        File npcFile = new File(folder, npcUUID.toString() + ".yml");
        if (npcFile.exists()) {
            LOGGER.log(Level.SEVERE, MessageFormat.format(WARN_NPC_RECREATE_1, name, npcUUID.toString()), new RuntimeException());
            LOGGER.log(Level.SEVERE, WARN_NPC_RECREATE_2);
        }
        EssentialsUserConf npcConfig = new EssentialsUserConf(name, npcUUID, npcFile);
        npcConfig.load();
        npcConfig.setProperty("npc", true);
        npcConfig.setProperty("lastAccountName", name);
        npcConfig.setProperty("money", ess.getSettings().getStartingBalance());
        npcConfig.forceSave();
        ess.getUserMap().trackUUID(npcUUID, name, false);
    }

    private static void deleteNPC(String name) {
        User user = ess.getUser(name);
        user.reset();
    }

    private static User getUserByName(String name) {
        Player player;
        if (ess == null) {
            throw new RuntimeException(WARN_CALL_BEFORE_LOAD);
        }
        if (name == null) {
            throw new IllegalArgumentException("Economy username cannot be null");
        }
        User user = ess.getUser(name);
        if (user == null && (player = ess.getServer().getPlayerExact(name)) != null && (user = ess.getUser(player.getUniqueId())) != null) {
            LOGGER.log(Level.INFO, MessageFormat.format(WARN_PLAYER_UUID_NO_NAME, name, player.getUniqueId().toString()), new RuntimeException());
        }
        return user;
    }

    private static User getUserByUUID(UUID uuid) {
        if (ess == null) {
            throw new RuntimeException(WARN_CALL_BEFORE_LOAD);
        }
        if (uuid == null) {
            throw new IllegalArgumentException("Economy uuid cannot be null");
        }
        return ess.getUser(uuid);
    }

    @Deprecated
    public static double getMoney(String name) throws UserDoesNotExistException {
        BigDecimal exactAmount = Economy.getMoneyExact(name);
        double amount = exactAmount.doubleValue();
        if (new BigDecimal(amount).compareTo(exactAmount) > 0) {
            amount = Math.nextAfter(amount, Double.NEGATIVE_INFINITY);
        }
        return amount;
    }

    @Deprecated
    public static BigDecimal getMoneyExact(String name) throws UserDoesNotExistException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        return Economy.getMoneyExact(user);
    }

    public static BigDecimal getMoneyExact(UUID uuid) throws UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        return Economy.getMoneyExact(user);
    }

    public static BigDecimal getMoneyExact(User user) {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        return user.getMoney();
    }

    @Deprecated
    public static void setMoney(String name, double balance) throws UserDoesNotExistException, NoLoanPermittedException {
        try {
            Economy.setMoney(name, BigDecimal.valueOf(balance));
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Failed to set balance of " + name + " to " + balance + ": " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static void setMoney(String name, BigDecimal balance) throws UserDoesNotExistException, NoLoanPermittedException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        Economy.setMoney(user, balance);
    }

    public static void setMoney(UUID uuid, BigDecimal balance) throws NoLoanPermittedException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        Economy.setMoney(user, balance);
    }

    public static void setMoney(User user, BigDecimal balance) throws NoLoanPermittedException {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        if (balance.compareTo(ess.getSettings().getMinMoney()) < 0) {
            throw new NoLoanPermittedException();
        }
        if (balance.signum() < 0 && !user.isAuthorized("essentials.eco.loan")) {
            throw new NoLoanPermittedException();
        }
        try {
            user.setMoney(balance, UserBalanceUpdateEvent.Cause.API);
        }
        catch (MaxMoneyException maxMoneyException) {
            // empty catch block
        }
        Trade.log("API", "Set", "API", user.getName(), new Trade(balance, ess), null, null, null, balance, ess);
    }

    @Deprecated
    public static void add(String name, double amount) throws UserDoesNotExistException, NoLoanPermittedException {
        try {
            Economy.add(name, BigDecimal.valueOf(amount));
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Failed to add " + amount + " to balance of " + name + ": " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static void add(String name, BigDecimal amount) throws UserDoesNotExistException, NoLoanPermittedException, ArithmeticException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        Economy.add(user, amount);
    }

    public static void add(UUID uuid, BigDecimal amount) throws NoLoanPermittedException, ArithmeticException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        Economy.add(user, amount);
    }

    public static void add(User user, BigDecimal amount) throws NoLoanPermittedException, ArithmeticException {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        BigDecimal result = Economy.getMoneyExact(user).add(amount, MATH_CONTEXT);
        Economy.setMoney(user, result);
        Trade.log("API", "Add", "API", user.getName(), new Trade(amount, ess), null, null, null, result, ess);
    }

    @Deprecated
    public static void subtract(String name, double amount) throws UserDoesNotExistException, NoLoanPermittedException {
        try {
            Economy.substract(name, BigDecimal.valueOf(amount));
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Failed to subtract " + amount + " of balance of " + name + ": " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static void substract(String name, BigDecimal amount) throws UserDoesNotExistException, NoLoanPermittedException, ArithmeticException {
        BigDecimal result = Economy.getMoneyExact(name).subtract(amount, MATH_CONTEXT);
        Economy.setMoney(name, result);
        Trade.log("API", "Subtract", "API", name, new Trade(amount, ess), null, null, null, result, ess);
    }

    public static void subtract(UUID uuid, BigDecimal amount) throws NoLoanPermittedException, ArithmeticException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        Economy.subtract(user, amount);
    }

    public static void subtract(User user, BigDecimal amount) throws NoLoanPermittedException, ArithmeticException {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        BigDecimal result = Economy.getMoneyExact(user).subtract(amount, MATH_CONTEXT);
        Economy.setMoney(user, result);
        Trade.log("API", "Subtract", "API", user.getName(), new Trade(amount, ess), null, null, null, result, ess);
    }

    @Deprecated
    public static void divide(String name, double amount) throws UserDoesNotExistException, NoLoanPermittedException {
        try {
            Economy.divide(name, BigDecimal.valueOf(amount));
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Failed to divide balance of " + name + " by " + amount + ": " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static void divide(String name, BigDecimal amount) throws UserDoesNotExistException, NoLoanPermittedException, ArithmeticException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        Economy.divide(user, amount);
    }

    public static void divide(UUID uuid, BigDecimal amount) throws NoLoanPermittedException, ArithmeticException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        Economy.divide(user, amount);
    }

    public static void divide(User user, BigDecimal amount) throws NoLoanPermittedException, ArithmeticException {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        BigDecimal result = Economy.getMoneyExact(user).divide(amount, MATH_CONTEXT);
        Economy.setMoney(user, result);
        Trade.log("API", "Divide", "API", user.getName(), new Trade(amount, ess), null, null, null, result, ess);
    }

    @Deprecated
    public static void multiply(String name, double amount) throws UserDoesNotExistException, NoLoanPermittedException {
        try {
            Economy.multiply(name, BigDecimal.valueOf(amount));
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Failed to multiply balance of " + name + " by " + amount + ": " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static void multiply(String name, BigDecimal amount) throws UserDoesNotExistException, NoLoanPermittedException, ArithmeticException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        Economy.multiply(user, amount);
    }

    public static void multiply(UUID uuid, BigDecimal amount) throws NoLoanPermittedException, ArithmeticException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        Economy.multiply(user, amount);
    }

    public static void multiply(User user, BigDecimal amount) throws NoLoanPermittedException, ArithmeticException {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        BigDecimal result = Economy.getMoneyExact(user).multiply(amount, MATH_CONTEXT);
        Economy.setMoney(user, result);
        Trade.log("API", "Multiply", "API", user.getName(), new Trade(amount, ess), null, null, null, result, ess);
    }

    @Deprecated
    public static void resetBalance(String name) throws UserDoesNotExistException, NoLoanPermittedException {
        if (ess == null) {
            throw new RuntimeException(WARN_CALL_BEFORE_LOAD);
        }
        Economy.setMoney(name, ess.getSettings().getStartingBalance());
        Trade.log("API", "Reset", "API", name, new Trade(BigDecimal.ZERO, ess), null, null, null, ess.getSettings().getStartingBalance(), ess);
    }

    public static void resetBalance(UUID uuid) throws NoLoanPermittedException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        Economy.resetBalance(user);
    }

    public static void resetBalance(User user) throws NoLoanPermittedException {
        if (ess == null) {
            throw new RuntimeException(WARN_CALL_BEFORE_LOAD);
        }
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        Economy.setMoney(user, ess.getSettings().getStartingBalance());
        Trade.log("API", "Reset", "API", user.getName(), new Trade(BigDecimal.ZERO, ess), null, null, null, ess.getSettings().getStartingBalance(), ess);
    }

    @Deprecated
    public static boolean hasEnough(String name, double amount) throws UserDoesNotExistException {
        try {
            return Economy.hasEnough(name, BigDecimal.valueOf(amount));
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Failed to compare balance of " + name + " with " + amount + ": " + e.getMessage(), e);
            return false;
        }
    }

    public static boolean hasEnough(String name, BigDecimal amount) throws UserDoesNotExistException, ArithmeticException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        return Economy.hasEnough(user, amount);
    }

    public static boolean hasEnough(UUID uuid, BigDecimal amount) throws ArithmeticException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        return Economy.hasEnough(user, amount);
    }

    public static boolean hasEnough(User user, BigDecimal amount) throws ArithmeticException {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        return amount.compareTo(Economy.getMoneyExact(user)) <= 0;
    }

    @Deprecated
    public static boolean hasMore(String name, double amount) throws UserDoesNotExistException {
        try {
            return Economy.hasMore(name, BigDecimal.valueOf(amount));
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Failed to compare balance of " + name + " with " + amount + ": " + e.getMessage(), e);
            return false;
        }
    }

    @Deprecated
    public static boolean hasMore(String name, BigDecimal amount) throws UserDoesNotExistException, ArithmeticException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        return Economy.hasMore(user, amount);
    }

    public static boolean hasMore(UUID uuid, BigDecimal amount) throws ArithmeticException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        return Economy.hasMore(user, amount);
    }

    public static boolean hasMore(User user, BigDecimal amount) throws ArithmeticException {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        return amount.compareTo(Economy.getMoneyExact(user)) < 0;
    }

    @Deprecated
    public static boolean hasLess(String name, double amount) throws UserDoesNotExistException {
        try {
            return Economy.hasLess(name, BigDecimal.valueOf(amount));
        }
        catch (ArithmeticException e) {
            LOGGER.log(Level.WARNING, "Failed to compare balance of " + name + " with " + amount + ": " + e.getMessage(), e);
            return false;
        }
    }

    @Deprecated
    public static boolean hasLess(String name, BigDecimal amount) throws UserDoesNotExistException, ArithmeticException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        return Economy.hasLess(user, amount);
    }

    public static boolean hasLess(UUID uuid, BigDecimal amount) throws ArithmeticException, UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        return Economy.hasLess(user, amount);
    }

    public static boolean hasLess(User user, BigDecimal amount) throws ArithmeticException {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        return amount.compareTo(Economy.getMoneyExact(user)) > 0;
    }

    @Deprecated
    public static boolean isNegative(String name) throws UserDoesNotExistException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        return Economy.isNegative(user);
    }

    public static boolean isNegative(UUID uuid) throws UserDoesNotExistException {
        User user = Economy.getUserByUUID(uuid);
        if (user == null) {
            throw new UserDoesNotExistException(uuid);
        }
        return Economy.isNegative(user);
    }

    public static boolean isNegative(User user) {
        if (user == null) {
            throw new IllegalArgumentException("Economy user cannot be null");
        }
        return Economy.getMoneyExact(user).signum() < 0;
    }

    @Deprecated
    public static String format(double amount) {
        try {
            return Economy.format(BigDecimal.valueOf(amount));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Failed to display " + amount + ": " + e.getMessage(), e);
            return "NaN";
        }
    }

    public static String format(BigDecimal amount) {
        if (ess == null) {
            throw new RuntimeException(WARN_CALL_BEFORE_LOAD);
        }
        return NumberUtil.displayCurrency(amount, ess);
    }

    @Deprecated
    public static boolean playerExists(String name) {
        return Economy.getUserByName(name) != null;
    }

    public static boolean playerExists(UUID uuid) {
        return Economy.getUserByUUID(uuid) != null;
    }

    public static boolean isNPC(String name) throws UserDoesNotExistException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        return user.isNPC();
    }

    public static boolean createNPC(String name) {
        User user = Economy.getUserByName(name);
        if (user == null) {
            Economy.createNPCFile(name);
            return true;
        }
        LOGGER.log(Level.WARNING, MessageFormat.format(WARN_EXISTING_NPC_CREATE, name, user.getConfigUUID()), new RuntimeException());
        return false;
    }

    public static void removeNPC(String name) throws UserDoesNotExistException {
        User user = Economy.getUserByName(name);
        if (user == null) {
            throw new UserDoesNotExistException(name);
        }
        Economy.deleteNPC(name);
    }
}

