/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.DateUtil;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class Commandcreatekit
extends EssentialsCommand {
    private static final String PASTE_URL = "https://paste.gg/";
    private static final String PASTE_UPLOAD_URL = "https://api.paste.gg/v1/pastes";
    private static final Gson GSON = new Gson();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private final YamlConstructor yamlConstructor = new YamlConstructor();

    public Commandcreatekit() {
        super("createkit");
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length != 2) {
            throw new NotEnoughArgumentsException();
        }
        long delay = Long.parseLong(args[1]);
        String kitname = args[0];
        ItemStack[] items = user.getBase().getInventory().getContents();
        ArrayList<String> list = new ArrayList<String>();
        for (ItemStack is : items) {
            if (is == null || is.getType() == null || is.getType() == Material.AIR) continue;
            String serialized = this.ess.getItemDb().serialize(is);
            list.add(serialized);
        }
        if (!this.ess.getSettings().isPastebinCreateKit()) {
            this.ess.getKits().addKit(kitname, list, delay);
            user.sendMessage(I18n.tl("createdKit", kitname, list.size(), delay));
        } else {
            MemoryConfiguration config = new MemoryConfiguration();
            config.set("kits." + kitname + ".delay", (Object)delay);
            config.set("kits." + kitname + ".items", list);
            Yaml yaml = new Yaml((BaseConstructor)this.yamlConstructor, this.yamlRepresenter, this.yamlOptions);
            String fileContents = "# Copy the kit code below into the kits section in your config.yml file\n";
            fileContents = fileContents + yaml.dump((Object)config.getValues(false));
            this.uploadPaste(user.getSource(), kitname, delay, fileContents);
        }
    }

    private void uploadPaste(CommandSource sender, String kitName, long delay, String contents) {
        this.executorService.submit(() -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(PASTE_UPLOAD_URL).openConnection();
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestProperty("User-Agent", "EssentialsX plugin");
                connection.setRequestProperty("Content-Type", "application/json");
                JsonObject body = new JsonObject();
                JsonArray files = new JsonArray();
                JsonObject file = new JsonObject();
                JsonObject content = new JsonObject();
                content.addProperty("format", "text");
                content.addProperty("value", contents);
                file.add("content", (JsonElement)content);
                files.add((JsonElement)file);
                body.add("files", (JsonElement)files);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(body.toString().getBytes(Charsets.UTF_8));
                }
                if (connection.getResponseCode() >= 400) {
                    sender.sendMessage(I18n.tl("createKitFailed", kitName));
                    String message = CharStreams.toString((Readable)new InputStreamReader(connection.getErrorStream(), Charsets.UTF_8));
                    this.ess.getLogger().severe("Error creating kit: " + message);
                    return;
                }
                JsonObject object = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream(), Charsets.UTF_8), JsonObject.class);
                String pasteUrl = PASTE_URL + object.get("result").getAsJsonObject().get("id").getAsString();
                connection.disconnect();
                String separator = I18n.tl("createKitSeparator", new Object[0]);
                String delayFormat = "0";
                if (delay > 0L) {
                    delayFormat = DateUtil.formatDateDiff(System.currentTimeMillis() + delay * 1000L);
                }
                sender.sendMessage(separator);
                sender.sendMessage(I18n.tl("createKitSuccess", kitName, delayFormat, pasteUrl));
                sender.sendMessage(separator);
                if (this.ess.getSettings().isDebug()) {
                    this.ess.getLogger().info(sender.getSender().getName() + " created a kit: " + pasteUrl);
                }
            }
            catch (Exception e) {
                sender.sendMessage(I18n.tl("createKitFailed", kitName));
                e.printStackTrace();
            }
        });
    }
}

