/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class Commandeditsign
extends EssentialsCommand {
    public Commandeditsign() {
        super("editsign");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        block15: {
            if (args.length == 0 || args.length > 1 && !NumberUtil.isInt(args[1])) {
                throw new NotEnoughArgumentsException();
            }
            Block target = user.getTargetBlock(5);
            if (!(target.getState() instanceof Sign)) {
                throw new Exception(I18n.tl("editsignCommandTarget", new Object[0]));
            }
            Sign sign = (Sign)target.getState();
            try {
                if (args[0].equalsIgnoreCase("set") && args.length > 2) {
                    int line = Integer.parseInt(args[1]) - 1;
                    String text = FormatUtil.formatString(user, "essentials.editsign", Commandeditsign.getFinalArg(args, 2)).trim();
                    if (ChatColor.stripColor((String)text).length() > 15 && !user.isAuthorized("essentials.editsign.unlimited")) {
                        throw new Exception(I18n.tl("editsignCommandLimit", new Object[0]));
                    }
                    sign.setLine(line, text);
                    sign.update();
                    user.sendMessage(I18n.tl("editsignCommandSetSuccess", line + 1, text));
                    break block15;
                }
                if (args[0].equalsIgnoreCase("clear")) {
                    if (args.length == 1) {
                        for (int i = 0; i < 4; ++i) {
                            sign.setLine(i, "");
                        }
                        sign.update();
                        user.sendMessage(I18n.tl("editsignCommandClear", new Object[0]));
                    } else {
                        int line = Integer.parseInt(args[1]) - 1;
                        sign.setLine(line, "");
                        sign.update();
                        user.sendMessage(I18n.tl("editsignCommandClearLine", line + 1));
                    }
                    break block15;
                }
                if (args[0].equalsIgnoreCase("copy") || args[0].equalsIgnoreCase("paste")) {
                    int line;
                    boolean copy = args[0].equalsIgnoreCase("copy");
                    String tlPrefix = copy ? "editsignCopy" : "editsignPaste";
                    int n = line = args.length == 1 ? -1 : Integer.parseInt(args[1]) - 1;
                    if (line == -1) {
                        for (int i = 0; i < 4; ++i) {
                            this.processSignCopyPaste(user, sign, i, copy);
                        }
                        user.sendMessage(I18n.tl(tlPrefix, commandLabel));
                    } else {
                        this.processSignCopyPaste(user, sign, line, copy);
                        user.sendMessage(I18n.tl(tlPrefix + "Line", line + 1, commandLabel));
                    }
                    if (!copy) {
                        sign.update();
                    }
                    break block15;
                }
                throw new NotEnoughArgumentsException();
            }
            catch (IndexOutOfBoundsException e) {
                throw new Exception(I18n.tl("editsignCommandNoLine", new Object[0]), e);
            }
        }
    }

    private void processSignCopyPaste(User user, Sign sign, int index, boolean copy) {
        if (copy) {
            user.getSignCopy().set(index, FormatUtil.unformatString(user, "essentials.editsign", sign.getLine(index)));
            return;
        }
        String line = FormatUtil.formatString(user, "essentials.editsign", user.getSignCopy().get(index));
        sign.setLine(index, line == null ? "" : line);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"set", "clear", "copy", "paste"});
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4"});
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("set") && NumberUtil.isPositiveInt(args[1])) {
            int line = Integer.parseInt(args[1]);
            Block target = user.getTargetBlock(5);
            if (target.getState() instanceof Sign && line <= 4) {
                Sign sign = (Sign)target.getState();
                return Lists.newArrayList((Object[])new String[]{FormatUtil.unformatString(user, "essentials.editsign", sign.getLine(line - 1))});
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

