/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.StringUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commanditemdb
extends EssentialsCommand {
    public Commanditemdb() {
        super("itemdb");
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        ItemStack itemStack = null;
        boolean itemHeld = false;
        if (args.length == 0) {
            if (sender.isPlayer() && sender.getPlayer() != null) {
                itemHeld = true;
                itemStack = this.ess.getUser(sender.getPlayer()).getItemInHand();
            }
            if (itemStack == null) {
                throw new NotEnoughArgumentsException();
            }
        } else {
            itemStack = this.ess.getItemDb().get(args[0]);
        }
        String itemId = "none";
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_13_0_R01)) {
            itemId = itemStack.getType().getId() + ":" + itemStack.getDurability();
        }
        sender.sendMessage(I18n.tl("itemType", itemStack.getType().toString(), itemId));
        if (!I18n.tl("itemType", new Object[0]).contains("{1}") && !itemId.equals("none")) {
            sender.sendMessage(I18n.tl("itemId", itemId));
        }
        if (itemHeld && itemStack.getType() != Material.AIR) {
            short maxuses = itemStack.getType().getMaxDurability();
            int durability = maxuses + 1 - itemStack.getDurability();
            if (maxuses != 0) {
                sender.sendMessage(I18n.tl("durability", Integer.toString(durability)));
            }
        }
        List<String> nameList = this.ess.getItemDb().nameList(itemStack);
        nameList.addAll(this.ess.getCustomItemResolver().getAliasesFor(this.ess.getItemDb().name(itemStack)));
        Collections.sort(nameList);
        if (nameList.size() > 15) {
            nameList = nameList.subList(0, 14);
        }
        String itemNameList = StringUtil.joinList(", ", nameList);
        sender.sendMessage(I18n.tl("itemNames", itemNameList));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getItems();
        }
        return Collections.emptyList();
    }
}

