/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.List;
import org.bukkit.Server;

public class Commandmsg
extends EssentialsLoopCommand {
    public Commandmsg() {
        super("msg");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        String message = Commandmsg.getFinalArg(args, 1);
        boolean canWildcard = sender.isAuthorized("essentials.msg.multiple", this.ess);
        if (sender.isPlayer()) {
            User user = this.ess.getUser(sender.getPlayer());
            if (user.isMuted()) {
                String dateDiff;
                String string = dateDiff = user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : null;
                if (dateDiff == null) {
                    throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReason", user.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
                }
                throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReasonTime", dateDiff, user.getMuteReason()) : I18n.tl("voiceSilencedTime", dateDiff));
            }
            message = FormatUtil.formatMessage(user, "essentials.msg", message);
        } else {
            message = FormatUtil.replaceFormat(message);
        }
        if (args[0].equalsIgnoreCase("Console") || args[0].equalsIgnoreCase(Console.DISPLAY_NAME)) {
            Console messageSender = sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : Console.getInstance();
            messageSender.sendMessage(Console.getInstance(), message);
            return;
        }
        this.loopOnlinePlayers(server, sender, false, canWildcard, args[0], new String[]{message});
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User messageReceiver, String[] args) {
        Console messageSender = sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : Console.getInstance();
        messageSender.sendMessage(messageReceiver, args[0]);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return null;
    }
}

