/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.DescParseTickFormat;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.bukkit.Server;
import org.bukkit.World;

public class Commandptime
extends EssentialsLoopCommand {
    private static final List<String> getAliases = Arrays.asList("get", "list", "show", "display");

    public Commandptime() {
        super("ptime");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        Long ticks;
        if (args.length == 0 || getAliases.contains(args[0].toLowerCase())) {
            if (args.length > 1) {
                if (args[1].equals("*") || args[1].equals("**")) {
                    sender.sendMessage(I18n.tl("pTimePlayers", new Object[0]));
                }
                this.loopOnlinePlayersConsumer(server, sender, false, true, args[1], player -> this.getUserTime(sender, player));
                return;
            }
            if (args.length == 1 || sender.isPlayer()) {
                if (sender.isPlayer()) {
                    this.getUserTime(sender, sender.getUser(this.ess));
                    return;
                }
                throw new NotEnoughArgumentsException();
            }
            if (this.ess.getOnlinePlayers().size() > 1) {
                sender.sendMessage(I18n.tl("pTimePlayers", new Object[0]));
            }
            for (User player2 : this.ess.getOnlineUsers()) {
                this.getUserTime(sender, player2);
            }
        }
        if (args.length > 1 && !sender.isAuthorized("essentials.ptime.others", this.ess) && !args[1].equalsIgnoreCase(sender.getSelfSelector())) {
            sender.sendMessage(I18n.tl("pTimeOthersPermission", new Object[0]));
            return;
        }
        String time = args[0];
        boolean fixed = time.startsWith("@");
        if (fixed) {
            time = time.substring(1);
        }
        if (DescParseTickFormat.meansReset(time)) {
            ticks = null;
        } else {
            try {
                ticks = DescParseTickFormat.parse(time);
            }
            catch (NumberFormatException e) {
                throw new NotEnoughArgumentsException(e);
            }
        }
        StringJoiner joiner = new StringJoiner(",");
        this.loopOnlinePlayersConsumer(server, sender, false, true, args.length > 1 ? args[1] : sender.getSelfSelector(), player -> {
            this.setUserTime(player, ticks, !fixed);
            joiner.add(player.getName());
        });
        if (ticks == null) {
            sender.sendMessage(I18n.tl("pTimeReset", joiner.toString()));
            return;
        }
        String formattedTime = DescParseTickFormat.format(ticks);
        sender.sendMessage(fixed ? I18n.tl("pTimeSetFixed", formattedTime, joiner.toString()) : I18n.tl("pTimeSet", formattedTime, joiner.toString()));
    }

    public void getUserTime(CommandSource sender, IUser user) {
        if (user == null) {
            return;
        }
        if (user.getBase().getPlayerTimeOffset() == 0L) {
            sender.sendMessage(I18n.tl("pTimeNormal", user.getName()));
            return;
        }
        String time = DescParseTickFormat.format(user.getBase().getPlayerTime());
        sender.sendMessage(user.getBase().isPlayerTimeRelative() ? I18n.tl("pTimeCurrent", user.getName(), time) : I18n.tl("pTimeCurrentFixed", user.getName(), time));
    }

    private void setUserTime(User user, Long ticks, Boolean relative) {
        if (ticks == null) {
            user.getBase().resetPlayerTime();
        } else {
            World world = user.getWorld();
            long time = user.getBase().getPlayerTime();
            time -= time % 24000L;
            time += 24000L + ticks;
            if (relative.booleanValue()) {
                time -= world.getTime();
            }
            user.getBase().setPlayerTime(time, relative.booleanValue());
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        User user = this.ess.getUser(sender.getPlayer());
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"get", "reset", "sunrise", "day", "morning", "noon", "afternoon", "sunset", "night", "midnight"});
        }
        if (args.length == 2 && (getAliases.contains(args[0]) || user == null || user.isAuthorized("essentials.ptime.others"))) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User user, String[] args) {
    }
}

